import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

final AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1]);
final File workDir = new File('.').canonicalFile
final CommandHelper cmdHelper = new CommandHelper(workDir);
final Properties stepProps = apTool.getStepProperties()
final File agvtoolFile = new File(stepProps['xcode_agvtool'])
final String techVersion = stepProps['xcode_techVersion']
final String marketingVersion = stepProps['xcode_marketingVersion']

if (techVersion) {
    final List<Object> techCommandLine = []
    techCommandLine << agvtoolFile.absolutePath
    techCommandLine << 'new-version'
    techCommandLine << techVersion
    println "Setting technical version ${techVersion}"
    cmdHelper.runCommand('Xcode Version', techCommandLine)
}

if (marketingVersion) {
    final List<Object> marketingCommandLine = []
    marketingCommandLine << agvtoolFile.absolutePath
    marketingCommandLine << 'new-marketing-version'
    marketingCommandLine << marketingVersion
    println "Setting technical version ${marketingVersion}"
    cmdHelper.runCommand('Xcode Version', marketingCommandLine)
}