import com.urbancode.air.CommandHelper

public class KeychainUtil {

    private static final String HOME = System.getenv()["HOME"]
    private static final String KEYCHAIN_DIR = "$HOME/Library/Keychains"

    // Cache the output from the readKeychainInfo method
    private keychainInfoText

    CommandHelper cmdHelper
    Integer currTimeout = 0
    boolean doCodeSign = false
    boolean shouldLockKeychain = false
    String keychainName
    String keychainPassword

    public KeychainUtil(CommandHelper cmdHelper) {
        this.cmdHelper = cmdHelper
    }

    public void setTimeout(timeout) {
        if (doCodeSign) {
            def timeoutCommand = ["security", "set-keychain-settings"]
            if (timeout != 0) {
                timeoutCommand << "-t" << timeout
            }
            timeoutCommand << "$KEYCHAIN_DIR/$keychainName"
            cmdHelper.runCommand('Setting keychain timeout', timeoutCommand)
        }
    }

    /**
     * returns true if the keychain is locked, false otherwise
     */
    public boolean isKeychainLocked() {
        boolean result = false
        if (doCodeSign) {
            readKeychainInfo('Checking if keychain is locked') { result = it.matches(~'(?s).*User interaction is not allowed\\.') }
        }
        return result
    }

    public void readCurrentTimeout() {
        if (doCodeSign) {
            if (keychainInfoText) {
                parseTimeout(keychainInfoText)
            }
            else {
                readKeychainInfo('Reading keychain timeout value') { parseTimeout(it) }
            }
        }
    }

    public void unlockKeychain() {
        if (doCodeSign) {
            shouldLockKeychain = true
            def unlockCommand = ["security", "-v", "unlock-keychain", "-p", keychainPassword, "$KEYCHAIN_DIR/$keychainName"]
            cmdHelper.runCommand('Unlocking keychain', unlockCommand)
        }
    }

    public void lockKeychain() {
        if (doCodeSign) {
            shouldLockKeychain = false
            def lockCommand = ["security", "-v", "lock-keychain", "$KEYCHAIN_DIR/$keychainName"]
            cmdHelper.runCommand('Locking keychain', lockCommand)
        }
    }

    private void readKeychainInfo(String message, Closure postProcess) {
        def showKeychainInfoCommand = getShowKeychainInfoCommand()
        cmdHelper.runCommand(message, showKeychainInfoCommand) { Process proc ->
            proc.out.close() // close stdin
            def keychainInfoText = proc.err.text.trim()
            println keychainInfoText
            postProcess(keychainInfoText)
        }
    }

    private Integer parseTimeout(def text) {
        def currTimeoutStr = text.find(~'timeout=(\\d+)s') { match, timeout -> return timeout }
        if (currTimeoutStr) {
            currTimeout = Integer.valueOf(currTimeoutStr)
        }
        else {
            // We get to this point if the keychain currently has no-timeout as a value. We treat 0 as no-timeout
            currTimeout = 0
        }
    }

    private def getShowKeychainInfoCommand() {
        return ["security", "-v", "show-keychain-info", "$KEYCHAIN_DIR/$keychainName"]
    }
}
