import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
final File workDir = new File('.').canonicalFile
final CommandHelper cmdHelper = new CommandHelper(workDir)

final Properties stepProps = apTool.getStepProperties()
final File xcrunFile            = new File(stepProps['xcode_xcrun'])
final String sdk                = stepProps['xcode_sdk']
final String application        = stepProps['xcode_application']
final String target             = stepProps['xcode_target']
final String developer          = stepProps['xcode_developer']
final String profile            = stepProps['xcode_profile']
final String ipaPath            = new File(workDir, "build/${target}/${application}.ipa").absolutePath
final String appPath            = "build/${target}/${application}.app"
final String keychainName       = stepProps['keychainName'] ?: "login.keychain"
final String keychainPassword   = stepProps['keychainPassword']
final Integer timeout           = stepProps['timeout'] ? Integer.valueOf(stepProps['timeout']) : null

KeychainUtil util = new KeychainUtil(cmdHelper)
util.keychainName = keychainName
util.keychainPassword = keychainPassword
util.doCodeSign = true

if (util.isKeychainLocked() && keychainPassword) {
    util.unlockKeychain()
}

// Set the new temporary timeout
util.readCurrentTimeout()
boolean resetTimeout = false
if (timeout && timeout != util.currTimeout) {
    util.setTimeout(timeout)
    resetTimeout = true
}

try {
    final List<Object> commandLine = []
    commandLine << xcrunFile.absolutePath
    commandLine << '-sdk'
    commandLine << sdk
    commandLine << 'PackageApplication'
    commandLine << '-v'
    commandLine << appPath
    commandLine << '-o'
    commandLine << ipaPath
    commandLine << '--sign'
    commandLine << developer
    commandLine << '--embed'
    commandLine << profile

    println "Packaging ${appPath} to ${ipaPath}"
    cmdHelper.runCommand('Xcode PackageApplication', commandLine)
}
finally {
    // Set timeout to its original setting
    if (resetTimeout) {
        util.setTimeout(util.currTimeout)
    }

    // Lock the keychain if it was originally locked
    if (util.shouldLockKeychain) {
        util.lockKeychain()
    }
}
