/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.checkstyle;

public class CheckstyleHandler extends org.xml.sax.helpers.DefaultHandler {

    String fileName
    def errorAttrs

    /**
     * Closure which takes the following parameters
     * @param findingId
     * @param findingFile
     * @param findingLine
     * @param findingName
     * @param findingSeverity
     * @param findingDesc
     * @param findingStatus
     */
    Closure addFinding

    CheckstyleHandler(def addFinding) {
        this.addFinding = addFinding
    }

    /**
     * {@inheritDoc}
     */
    @Override
    void startElement(String ns, String localName, String qName, org.xml.sax.Attributes attribs) {
        switch (qName) {
           case 'file':
               fileName = attribs.getValue('name')
               break
           case 'error':
               errorAttrs = attribs;
               break
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    void endElement(String ns, String localName, String qName) {
        switch (qName) {
            case 'error':
                String line = errorAttrs.getValue('line')
                String severity = errorAttrs.getValue('severity')
                String description = errorAttrs.getValue('message')
                String source = errorAttrs.getValue('source')
                source = source.substring(source.lastIndexOf(".") + 1)

                addFinding('', fileName, line, source, severity, description, '')

                break
        }
    }
}