/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.helper;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadHelper {
    private static final String BOUNDARY = "---------------8jujieu8479wueire584w9en";
    private File sourceDir = null;

    public UploadHelper(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void sendPostRequest(String name, List<File> reportFiles) {
        HttpResponse response;
        if (reportFiles == null || reportFiles.isEmpty()) {
            System.out.println("No report was able to be generated");
            return;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            System.out.println("Report name must be provided");
            return;
        }
        String authToken = System.getenv("AUTH_TOKEN");
        String buildLifeId = System.getenv("BUILD_LIFE_ID");
        String reportName = URLEncoder.encode(name);
        String jobId = System.getenv("JOB_ID");
        if (StringUtils.isBlank((CharSequence)jobId)) {
            System.out.println("A job ID must be provided");
            return;
        }
        String baseUrl = System.getenv("WEB_URL");
        baseUrl = baseUrl + (baseUrl.endsWith("/") ? "" : "/");
        String url = baseUrl + "rest/buildlife/" + buildLifeId + "/publishedReports";
        System.out.println("Sending request to " + url);
        HttpPost postMethod = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            postMethod.addHeader("Authorization-Token", authToken);
            postMethod.addHeader("Content-Type", "multipart/mixed;boundary=---------------8jujieu8479wueire584w9en");
        }
        System.out.println("Uploading " + reportFiles.size() + " files in report \"" + name + "\" to build life " + buildLifeId);
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT, BOUNDARY, StandardCharsets.UTF_8);
        try {
            multipartEntity.addPart("reportName", (ContentBody)new StringBody(reportName, StandardCharsets.UTF_8));
            multipartEntity.addPart("pathSeparator", (ContentBody)new StringBody(File.separator, StandardCharsets.UTF_8));
            multipartEntity.addPart("jobId", (ContentBody)new StringBody(jobId, StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to build multipart entity", e);
        }
        int i = 0;
        for (File reportFile : reportFiles) {
            String uniqueFieldName = "file" + i;
            String filePath = FileUtils.getRelativeFileName(this.sourceDir, reportFile);
            filePath = filePath.replace(File.separator, "/");
            FileBody fileBody = new FileBody(reportFile, filePath, "application/octet-stream", StandardCharsets.UTF_8.displayName());
            multipartEntity.addPart(uniqueFieldName, (ContentBody)fileBody);
            ++i;
        }
        postMethod.setEntity((HttpEntity)multipartEntity);
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTrustAllCerts(true);
        DefaultHttpClient client = builder.buildClient();
        try {
            response = client.execute((HttpUriRequest)postMethod);
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an exception when uploading files", e);
        }
        StatusLine statusLine = response.getStatusLine();
        int responseCode = statusLine.getStatusCode();
        HttpEntity entity = response.getEntity();
        if (this.isGoodResponseCode(responseCode)) {
            try {
                System.out.println(this.getEntityString(entity));
            }
            catch (IOException e) {
                throw new RuntimeException("Response indicated success but encountered an exception when copying response to standard output", e);
            }
        }
        try {
            System.err.println(this.getEntityString(entity));
        }
        catch (IOException e) {
            System.err.println("Failed to copy error response to standard error: " + e.getMessage());
        }
        throw new RuntimeException("Failed to upload reports. StatusCode: " + responseCode);
        System.out.println("Finished uploading all report files back to UrbanCode Build.");
    }

    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private String getEntityString(HttpEntity entity) throws IOException {
        return EntityUtils.toString((HttpEntity)entity, (Charset)IO.utf8());
    }
}

