/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.helper.UploadHelper;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Build {
    private final Properties outProps;
    private final File workDir;
    private String DBB_HOME;
    private final String groovyOptions;
    private final String buildScriptPath;
    private final String groovyArgs;
    private final String reportsDir;

    public Build(Properties inputProperties, Properties outputProperties) {
        this.initLog4j();
        this.outProps = outputProperties;
        this.DBB_HOME = inputProperties.getProperty("DBB_HOME");
        this.groovyOptions = inputProperties.getProperty("groovyOptions");
        this.buildScriptPath = inputProperties.getProperty("buildScriptPath");
        this.groovyArgs = inputProperties.getProperty("groovyArgs");
        this.reportsDir = inputProperties.getProperty("reportsDir");
        this.workDir = this.initWorkDir();
        if (StringUtils.isBlank((CharSequence)this.DBB_HOME)) {
            this.DBB_HOME = System.getenv("DBB_HOME");
            if (StringUtils.isBlank((CharSequence)this.DBB_HOME)) {
                throw new RuntimeException("DBB_HOME has not been specified.");
            }
        }
    }

    public int execute() {
        int exitValue;
        File dbbHomeDir = new File(this.DBB_HOME);
        if (!dbbHomeDir.exists() || !dbbHomeDir.isDirectory()) {
            this.error("DBB_HOME path does not exist or is not a directory: " + this.DBB_HOME);
            return 1;
        }
        if (!this.DBB_HOME.endsWith("/")) {
            this.DBB_HOME = this.DBB_HOME + "/";
        }
        File[] dbbHomeFiles = dbbHomeDir.listFiles();
        String groovyDirName = null;
        for (File dbbHomeFile : dbbHomeFiles) {
            String fileName = dbbHomeFile.getName();
            if (!fileName.startsWith("groovy")) continue;
            groovyDirName = fileName;
            break;
        }
        if (StringUtils.isEmpty(groovyDirName)) {
            this.error("Unable to find a Groovy directory in DBB home: " + this.DBB_HOME);
            return 1;
        }
        File groovyHomeDir = new File(this.DBB_HOME, groovyDirName);
        if (!groovyHomeDir.exists() || !groovyHomeDir.isDirectory()) {
            this.error("GROOVY_HOME path does not exist or is not a directory: " + this.DBB_HOME);
            return 1;
        }
        File buildScriptFile = new File(this.buildScriptPath);
        if (!buildScriptFile.exists() || !buildScriptFile.isFile()) {
            this.error("Build script file \"" + this.buildScriptPath + "\" does not exist or is not a regular file.");
            return 1;
        }
        List<String> cmdArgs = this.buildCmdArgsList();
        ProcessBuilder procBuilder = new ProcessBuilder(cmdArgs);
        procBuilder.environment().put("GROOVY_HOME", groovyHomeDir.getAbsolutePath());
        procBuilder.redirectErrorStream(true);
        try {
            System.out.println("Executing: " + StringUtils.join(cmdArgs, (String)" "));
            Process proc = procBuilder.start();
            InputStream input = proc.getInputStream();
            proc.getOutputStream().close();
            InputStreamReader inputReader = IO.reader(input, Charset.defaultCharset());
            PrintStream outputStream = new PrintStream(System.out, true);
            IO.copy((Reader)inputReader, outputStream);
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            exitValue = proc.exitValue();
            if (exitValue == 0 && StringUtils.isNotBlank((CharSequence)this.reportsDir)) {
                File reportsDirectory = new File(this.reportsDir);
                if (reportsDirectory.exists() && reportsDirectory.isDirectory()) {
                    List<File> reportFiles = this.getReportFiles();
                    if (reportFiles.size() == 0) {
                        System.out.println("No report files were found in reports directory \"" + this.reportsDir + "\".");
                    } else {
                        UploadHelper helper = new UploadHelper(new File(this.reportsDir));
                        helper.sendPostRequest("DBB Report", reportFiles);
                    }
                } else {
                    System.out.println("The specified reports directory \"" + this.reportsDir + "\" does not exist or is not a directory.");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error encountered while reading from process input stream", e);
        }
        return exitValue;
    }

    private void error(String msg) {
        System.err.println(msg);
    }

    private File initWorkDir() {
        File workDir;
        try {
            workDir = new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return workDir;
    }

    private List<String> buildCmdArgsList() {
        String[] optsArray = this.groovyOptions.split("\\s+");
        String[] argsArray = this.groovyArgs.split("\\s+");
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(this.DBB_HOME + "bin/groovyz");
        Collections.addAll(cmdArgs, optsArray);
        cmdArgs.add(this.buildScriptPath);
        Collections.addAll(cmdArgs, argsArray);
        return cmdArgs;
    }

    private List<File> getReportFiles() {
        ArrayList<File> reportFiles = new ArrayList<File>();
        Iterator it = FileUtils.getDirectoryFiles(new File(this.reportsDir));
        while (it.hasNext()) {
            File reportFile = (File)it.next();
            reportFiles.add(reportFile);
        }
        return reportFiles;
    }

    private void initLog4j() {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("[%-5p] %d{MM-dd-yyyy HH:mm:ss} %c - %m%n");
        consoleAppender.setLayout((Layout)layout);
        rootLogger.addAppender((Appender)consoleAppender);
        rootLogger.setLevel(Level.WARN);
    }
}

