/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.urbancode.commons.util.concurrent.ThreadFactoryListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final String name;
    private final ThreadGroup group;
    private final ThreadGroup finalizerGroup;
    private final boolean daemon;
    private final CopyOnWriteArrayList<ThreadFactoryListener> listeners = new CopyOnWriteArrayList();

    public NamedThreadFactory(String name, ThreadMode threadMode) {
        this.name = name;
        this.daemon = threadMode == ThreadMode.DAEMON;
        this.group = new NamedThreadGroup(name);
        this.group.setDaemon(true);
        this.finalizerGroup = new ThreadGroup(this.group, name + "-FinalizerGroup");
    }

    @Override
    public Thread newThread(Runnable runnable) {
        NamedThread thread = new NamedThread(this.group, runnable, this.nextThreadName());
        thread.setDaemon(this.daemon);
        for (ThreadFactoryListener listener : this.listeners) {
            listener.threadCreated(thread);
        }
        return thread;
    }

    public String getName() {
        return this.name;
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    protected int nextId() {
        return this.counter.getAndIncrement();
    }

    protected String nextThreadName() {
        return this.getName() + "-" + this.nextId();
    }

    public void addThreadFactoryListener(ThreadFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeThreadFactoryListener(ThreadFactoryListener listener) {
        this.listeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.finalizerGroup.destroy();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    private static final class NamedThreadGroup
    extends ThreadGroup {
        private final Logger log;

        NamedThreadGroup(String name) {
            super(name);
            this.log = Logger.getLogger((String)(NamedThreadFactory.class.getName() + "[" + name + "]"));
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.fatal((Object)(t + " terminated due to uncaught exception: " + e), e);
        }
    }

    private static final class NamedThread
    extends Thread {
        NamedThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                NDC.remove();
            }
        }
    }

    public static enum ThreadMode {
        DAEMON,
        NON_DAEMON;

    }
}

