/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.controller.RedirectResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;

public class RedirectHTMLResponse
extends RedirectResponse {
    private static final String CONTENT_RESOURCE = "RedirectHTMLResponse.html";

    public RedirectHTMLResponse(String destination) {
        super(destination);
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        InputStream templateStream = RedirectHTMLResponse.class.getResourceAsStream(CONTENT_RESOURCE);
        Validate.notNull((Object)templateStream, (String)"Did not find RedirectHTMLResponse.html resource.");
        String content = IO.readText((InputStream)templateStream);
        String url = this.computeUrl(request, response);
        content = content.replace("${DESTINATION}", StringEscapeUtils.escapeXml((String)url));
        String encoding = response.getCharacterEncoding();
        byte[] data = content.getBytes(encoding);
        response.setContentLength(data.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }
}

