/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.commons.profiler.ProfilerException;
import com.urbancode.commons.web.util.CurrentSessionHelper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class Session2ThreadBindingFilter
implements Filter {
    private static Logger logger = Logger.getLogger(Session2ThreadBindingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)request).getSession();
        if (CurrentSessionHelper.hasCurrent()) {
            CurrentSessionHelper.getCurrent().unbindThread();
        }
        try {
            logger.debug((Object)("Binding session " + session.getId() + " to thread #" + Thread.currentThread().getId()));
            CurrentSessionHelper helper = new CurrentSessionHelper(session);
            helper.bindCurrentThread();
        }
        catch (ProfilerException e) {
            throw new ServletException("Binding session to thread", (Throwable)e);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
        logger.info((Object)"Filter initialized");
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

