/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullSet;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public class NonNullMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> delegate;

    NonNullMap(Map<K, V> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public V put(K key, V value) {
        Check.nonNull(key, "key");
        Check.nonNull(value, "value");
        return this.delegate.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new NonNullSet<Map.Entry<K, V>>(this.delegate.entrySet());
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }
}

