/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs.hash;

import com.urbancode.commons.util.crypto.algs.AbstractCryptStringAlgorithm;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

public abstract class AbstractHashAlgorithm
extends AbstractCryptStringAlgorithm
implements CryptStringAlgorithm {
    protected static int SALT_128_bit = 16;
    protected static int SALT_160_bit = 20;
    protected static int SALT_256_bit = SALT_128_bit * 2;
    protected static int SALT_512_bit = SALT_256_bit * 2;
    private SecureRandom secureRandom = null;

    @Override
    public boolean usesAlg(String encoded) {
        throw new UnsupportedOperationException("It is not possible to determine if a secure hash uses a given algorithm");
    }

    @Override
    public final boolean isDecodeSupported() {
        return false;
    }

    @Override
    public final String decode(String encoded) throws GeneralSecurityException {
        throw new UnsupportedOperationException("It is not possible to reverse a secure hash");
    }

    protected byte[] randomSalt(int bytesLen) {
        SecureRandom sr = this.getSecureRandom();
        byte[] salt = new byte[bytesLen];
        sr.nextBytes(salt);
        return salt;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    @Override
    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }
}

