/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DisableUrlSessionFilter
implements Filter {
    private static Logger logger = Logger.getLogger(DisableUrlSessionFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        if (httpRequest.isRequestedSessionIdFromURL() && (session = httpRequest.getSession()) != null) {
            session.invalidate();
        }
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(httpResponse){

            public String encodeRedirectUrl(String url) {
                return url;
            }

            public String encodeRedirectURL(String url) {
                return url;
            }

            public String encodeUrl(String url) {
                return url;
            }

            public String encodeURL(String url) {
                return url;
            }
        };
        filterChain.doFilter(servletRequest, (ServletResponse)wrappedResponse);
    }

    public void init(FilterConfig config) {
        logger.info((Object)"Filter initialized");
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

