/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLColor {
    private static Logger log = Logger.getLogger(HTMLColor.class);
    private static Collection<HTMLColor> colors;
    private String name;
    private String hexCode;

    public static synchronized Collection<HTMLColor> getColors() {
        if (colors == null) {
            Properties colorProps = new Properties();
            try {
                ArrayList<HTMLColor> colorList = new ArrayList<HTMLColor>();
                log.debug((Object)"Loading properties");
                colorProps.load(HTMLColor.class.getClassLoader().getResourceAsStream("html_colors.properties"));
                log.debug((Object)("Loaded " + colorProps.size() + " colors"));
                Enumeration<Object> colorEnum = colorProps.keys();
                while (colorEnum.hasMoreElements()) {
                    String colorName = ((String)colorEnum.nextElement()).trim();
                    String colorHex = colorProps.getProperty(colorName).trim();
                    colorList.add(new HTMLColor(colorName, colorHex));
                }
                Collections.sort(colorList, new HTMLColorComparator());
                colors = Collections.unmodifiableList(colorList);
            }
            catch (IOException e) {
                log.debug((Object)("Unable to load HTML Colors from property file: " + e.getMessage()));
            }
        }
        return colors;
    }

    public HTMLColor(String name, String hexCode) {
        this.setName(name);
        this.setHexCode(hexCode);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHexCode() {
        return this.hexCode;
    }

    public void setHexCode(String hexCode) {
        this.hexCode = hexCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HTMLColorComparator
    implements Comparator<HTMLColor>,
    Serializable {
        private static final long serialVersionUID = 8997418204906481931L;

        @Override
        public int compare(HTMLColor c1, HTMLColor c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }
}

