/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.AImmutableVector;
import com.urbancode.commons.util.immutable.Box;
import com.urbancode.commons.util.immutable.IImmutableVector;
import com.urbancode.commons.util.immutable.Util;
import java.util.List;

public class ImmutableVector<T>
extends AImmutableVector<T> {
    final int cnt;
    final int shift;
    final Object[] root;
    final Object[] tail;
    private static final ImmutableVector<?> EMPTY = new ImmutableVector(0, 5, Util.EMPTY_ARRAY, Util.EMPTY_ARRAY);

    public static <T> ImmutableVector<T> empty() {
        return EMPTY;
    }

    public static <T> ImmutableVector<T> create(List<? extends T> items) {
        IImmutableVector<T> ret = ImmutableVector.empty();
        for (T item : items) {
            ret = ret.with((Object)item);
        }
        return ret;
    }

    public static <T> ImmutableVector<T> create(T ... items) {
        IImmutableVector<T> ret = ImmutableVector.empty();
        for (T item : items) {
            ret = ret.with((Object)item);
        }
        return ret;
    }

    ImmutableVector(int cnt, int shift, Object[] root, Object[] tail) {
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    @Override
    public T get(int i) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailOffset()) {
                return (T)this.tail[i & 0x1F];
            }
            Object[] arr = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                arr = (Object[])arr[i >>> level & 0x1F];
            }
            return (T)arr[i & 0x1F];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ImmutableVector<T> with(int i, T val) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailOffset()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val;
                return new ImmutableVector<T>(this.cnt, this.shift, this.root, newTail);
            }
            return new ImmutableVector<T>(this.cnt, this.shift, ImmutableVector.doAssoc(this.shift, this.root, i, val), this.tail);
        }
        if (i == this.cnt) {
            return this.with((Object)val);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.cnt;
    }

    @Override
    public ImmutableVector<T> with(T val) {
        if (this.tail.length < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val;
            return new ImmutableVector<T>(this.cnt + 1, this.shift, this.root, newTail);
        }
        Box expansion = new Box(null);
        Object[] newRoot = this.pushTail(this.shift - 5, this.root, this.tail, expansion);
        int newShift = this.shift;
        if (expansion.val != null) {
            newRoot = new Object[]{newRoot, expansion.val};
            newShift += 5;
        }
        return new ImmutableVector<T>(this.cnt + 1, newShift, newRoot, new Object[]{val});
    }

    @Override
    public ImmutableVector<T> pop() {
        if (this.cnt == 0) {
            throw new IllegalStateException("Can't pop empty vector");
        }
        if (this.cnt == 1) {
            return ImmutableVector.empty();
        }
        if (this.tail.length > 1) {
            Object[] newTail = new Object[this.tail.length - 1];
            System.arraycopy(this.tail, 0, newTail, 0, newTail.length);
            return new ImmutableVector<T>(this.cnt - 1, this.shift, this.root, newTail);
        }
        Box ptail = new Box(null);
        Object[] newroot = this.popTail(this.shift - 5, this.root, ptail);
        int newshift = this.shift;
        if (newroot == null) {
            newroot = Util.EMPTY_ARRAY;
        }
        if (this.shift > 5 && newroot.length == 1) {
            newroot = (Object[])newroot[0];
            newshift -= 5;
        }
        return new ImmutableVector<T>(this.cnt - 1, newshift, newroot, (Object[])ptail.val);
    }

    private int tailOffset() {
        return this.cnt - this.tail.length;
    }

    private Object[] pushTail(int level, Object[] arr, Object[] tailNode, Box expansion) {
        Object newchild;
        if (level == 0) {
            newchild = tailNode;
        } else {
            newchild = this.pushTail(level - 5, (Object[])arr[arr.length - 1], tailNode, expansion);
            if (expansion.val == null) {
                Object[] ret = (Object[])arr.clone();
                ret[arr.length - 1] = newchild;
                return ret;
            }
            newchild = expansion.val;
        }
        if (arr.length == 32) {
            expansion.val = new Object[]{newchild};
            return arr;
        }
        Object[] ret = new Object[arr.length + 1];
        System.arraycopy(arr, 0, ret, 0, arr.length);
        ret[arr.length] = newchild;
        expansion.val = null;
        return ret;
    }

    private Object[] popTail(int shift, Object[] arr, Box ptail) {
        Object[] newchild;
        if (shift > 0 && (newchild = this.popTail(shift - 5, (Object[])arr[arr.length - 1], ptail)) != null) {
            Object[] ret = (Object[])arr.clone();
            ret[arr.length - 1] = newchild;
            return ret;
        }
        if (shift == 0) {
            ptail.val = arr[arr.length - 1];
        }
        if (arr.length == 1) {
            return null;
        }
        Object[] ret = new Object[arr.length - 1];
        System.arraycopy(arr, 0, ret, 0, ret.length);
        return ret;
    }

    private static Object[] doAssoc(int level, Object[] arr, int i, Object val) {
        Object[] ret = (Object[])arr.clone();
        if (level == 0) {
            ret[i & 0x1F] = val;
        } else {
            int subidx = i >>> level & 0x1F;
            ret[subidx] = ImmutableVector.doAssoc(level - 5, (Object[])arr[subidx], i, val);
        }
        return ret;
    }
}

