/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import org.apache.http.client.HttpClient
import org.codehaus.jettison.json.JSONObject
import com.urbancode.commons.util.IO
import org.apache.http.client.methods.CloseableHttpResponse
import com.urbancode.commons.web.util.PercentCodec
import org.apache.http.client.methods.HttpRequestBase
import org.apache.http.entity.StringEntity
import org.apache.commons.codec.EncoderException
import org.apache.http.client.ClientProtocolException
import org.apache.commons.lang3.StringUtils
import org.apache.log4j.Logger

class HelperBase {
    private Logger log = Logger.getLogger(HelperBase.class)

    def workDir
    def javaFile
    def udClientJarFile

    def CommandHelper cmdHelper

    def url
    def user
    def password
    def ucdAuthToken

    def HttpClient client

    public void addCredentials(def command) {
        if (ucdAuthToken) {
            command << "--authtoken" << ucdAuthToken
        }
        else {
            command << "--username" << user << "--password" << password
        }
    }

    public CommandHelper getCommandHelper() {
        if (!cmdHelper) {
            cmdHelper = new CommandHelper(workDir)
        }
        return cmdHelper
    }

    public HttpClient getHttpClient() {
        if (!client) {
            def httpUser = user
            def httpPassword = password
            if (ucdAuthToken) {
                httpUser = "PasswordIsAuthToken"

                JSONObject tokenJson = new JSONObject()
                tokenJson.put("token", ucdAuthToken)
                httpPassword = tokenJson.toString()
            }

            HttpClientBuilder clientBuilder = new HttpClientBuilder()
            clientBuilder.setTrustAllCerts(true)
            clientBuilder.setPreemptiveAuthentication(true)
            clientBuilder.setUsername(httpUser)
            clientBuilder.setPassword(httpPassword)

            if (!StringUtils.isEmpty(System.getenv("PROXY_HOST")) &&
                    StringUtils.isNumeric(System.getenv("PROXY_PORT"))) {
                log.debug("Configuring proxy settings.")
                clientBuilder.setProxyHost(System.getenv("PROXY_HOST"))
                clientBuilder.setProxyPort(Integer.valueOf(System.getenv("PROXY_PORT")))
            }

            if (!StringUtils.isEmpty(System.getenv("PROXY_USERNAME")) &&
                    !StringUtils.isEmpty(System.getenv("PROXY_PASSWORD"))) {
                log.debug("Configuring proxy settings.")
                clientBuilder.setProxyUsername(System.getenv("PROXY_USERNAME"))
                clientBuilder.setProxyPassword(System.getenv("PROXY_PASSWORD"))
            }

            client = clientBuilder.buildClient()
        }
        return client
    }

    protected String encodePath(String path) {
        String result
        try {
            result = sanitizePathSegment(path)
        }
        catch (Exception e) {
            log.debug("the user input " + path + " could not be sanitized. defaulting to user input", e)
            result = path
        }
        return result
    }

    protected String sanitizePathSegment(String path)
    throws URISyntaxException, EncoderException {
        PercentCodec encoder = new PercentCodec()
        return encoder.encode(path)
    }

    protected StringEntity getStringEntity(Object object) {
        return new StringEntity(object.toString(), "UTF-8")
    }

    protected CloseableHttpResponse invokeMethod(HttpRequestBase request)
    throws IOException, ClientProtocolException {
        CloseableHttpResponse response = getHttpClient().execute(request)

        int status = response.getStatusLine().getStatusCode()
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s",
                    response.getStatusLine().getStatusCode(),
                    response.getStatusLine().getReasonPhrase(),
                    getBody(response)))
        }
        return response
    }

    protected String getBody(CloseableHttpResponse response)
    throws IOException {
        String result = null
        StringBuilder builder = new StringBuilder()

        if (response.getStatusLine().getStatusCode() != 204) {
            InputStream body = response.getEntity().getContent()
            if (body != null) {
                Reader reader = IO.reader(body, IO.utf8())
                try {
                    IO.copy(reader, builder)
                }
                finally {
                    reader.close()
                }
            }
            result = builder.toString()
        }
        // Else if the response was "No Content" we should pass back null

        return result
    }
}
