<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty"%>

<%@attribute name="name" required="true"%>
<%@attribute name="value" required="false"%>

<%@attribute name="id"      required="false" type="java.lang.String"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:if test="${empty value}">
	<c:choose>
		<c:when test="${requestScope[name] != null}">
			<c:set var="value" value="${requestScope[name]}" />
		</c:when>
		<c:when test="${param[name] != null}">
			<c:set var="value" value="${param[name]}" />
		</c:when>
	</c:choose>
</c:if>

<%--
<c:if test="${id==null}">
 <c:set var="id" value="${fn:toLowerCase(name)}"/>
 <c:set var="id"  value="${fn:replace(id, ' ', '_')}"/>
 <c:set var="id"  value="${fn:replace(id, '-', '_')}"/>
</c:if>
--%>

<c:if test="${!empty value}">
	<input type="hidden" <c:if test="${!empty id}">id="${id}"</c:if> name="${fn:escapeXml(name)}" value="${fn:escapeXml(value)}" />
</c:if>