/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def buildLifeId = System.getenv('BUILD_LIFE_ID')

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

def url                 = props['automation/url']
def user                = props['automation/user']
def ucdAuthToken        = props["job/ucdUserAuthToken"] ?: props["buildlife/ucdUserAuthToken"] ?: props['automation/authToken']
def password            = props['automation/passScript'] ?: props['automation/password']
def componentName       = props['componentName']
def versionName         = props['versionName']
def propertiesTextArea  = props['propertiesTextArea']
def testPercentage      = Boolean.valueOf(props['testPercentage'])
def codeAnalytics       = Boolean.valueOf(props['codeAnalytics'])
def codeCoverage        = Boolean.valueOf(props['codeCoverage'])
def sourceChange        = Boolean.valueOf(props['sourceChange'])
def workItem            = Boolean.valueOf(props['workItem'])

UCDBase ucd = new UCDBase()
ucd.user = user
ucd.password = password
ucd.ucdAuthToken = ucdAuthToken

Properties propertiesList = new Properties()
if (propertiesTextArea) {
    propertiesList.load(new StringReader(propertiesTextArea))
}

Properties properties = new BuildLifeHelper(buildLifeId).addBuildLifeMetricsProperties(testPercentage, codeAnalytics, codeCoverage, sourceChange, workItem)
propertiesList.putAll(properties)

def httpHelper = new HttpHelper()
httpHelper.setHttpClient(ucd.getHttpClient())
def propsHelper = new PropsHelper(httpHelper)
propsHelper.setComponentVersionProperties(url, componentName, versionName, propertiesList)
