/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import javax.ws.rs.core.UriBuilder;

public class PropsHelper {
    
    final private HttpHelper httpHelper;
    
    public PropsHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }
    
    /**
     * Set component version properties using line-separated properties from a text area input.
     */
    public void setComponentVersionProperties(String url, String componentName, String versionName, String propertiesTextArea) {
        if (!propertiesTextArea) {
            println "No properties defined to set"
            return
        }
        
        def propertiesToSet = new Properties()
        propertiesToSet.load(new StringReader(propertiesTextArea))
        setComponentVersionProperties(url, componentName, versionName, propertiesToSet)
    }

    /**
     * Set component version properties using a Properties object.
     */
    public void setComponentVersionProperties(String url, String componentName, String versionName, Properties propertiesToSet) {
        if (propertiesToSet.isEmpty()) {
            println "No properties defined to set"
            return
        }

        def versionPropertyUrl = UriBuilder.fromUri(url).segment("cli", "version", "versionProperties").build().toString()

        for (def propertyName : propertiesToSet.keySet()) {
            def propertyValue = propertiesToSet.getProperty(propertyName) ?: ""
            println "Updating property ${propertyName} with value ${propertyValue}"
            def propertiesJson = new JSONObject()
            propertiesJson.put("component", componentName)
            propertiesJson.put("version", versionName)
            propertiesJson.put("name", propertyName)
            propertiesJson.put("value", propertyValue)
            httpHelper.putContent(versionPropertyUrl, propertiesJson.toString())
        }

        println "${componentName} ${versionName} properties updated successfully"
    }
    
    private String getPropDefsUrl(String url, String componentName) {
        // you can only create properties on the version that are defined on the component
        def componentUrl = UriBuilder.fromUri(url).segment("rest", "deploy", "component", componentName).build().toString()
        println "Component URL: ${componentUrl}"
        def componentContent = httpHelper.getContent(componentUrl)
        println "Component JSON:\n${componentContent}"
        
        def componentJson = new JSONObject(componentContent)
        def componentId = componentJson.getString("id")
        def propSheetDefPath = componentJson.getJSONObject("versionPropSheetDef").getString("path")
        propSheetDefPath += "." + componentJson.getJSONObject("versionPropSheetDef").getString("version")
        def propDefsUrl = UriBuilder.fromUri(url).segment("property", "propSheetDef", propSheetDefPath, "propDefs").build().toString()

    }
}
