/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.ds.client.AddVersionFilesCommand;
import com.urbancode.ds.client.ClientCommand;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.ClientConfigurationDownloader;
import com.urbancode.ds.client.CommandLineParser;
import com.urbancode.ds.client.JSONPrinter;
import com.urbancode.ds.client.MissingRequiredParameterException;
import com.urbancode.ds.client.ParsedCommandLine;
import com.urbancode.ds.client.UnknownCommandException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.codehaus.jettison.json.JSONObject;

public final class DeployCLI {
    public static final String FLAG_HELP = "help";
    public static final String FLAG_VERBOSE = "verbose";
    public static final String OPTION_WEB_URL = "weburl";
    public static final String OPTION_AUTH_TOKEN = "authtoken";
    public static final String OPTION_USERNAME = "username";
    public static final String OPTION_PASSWORD = "password";
    public static final String ENV_WEB_URL = "DS_WEB_URL";
    public static final String ENV_AUTH_TOKEN = "DS_AUTH_TOKEN";
    public static final String ENV_USERNAME = "DS_USERNAME";
    public static final String ENV_PASSWORD = "DS_PASSWORD";
    public static final String PRODUCT_NAME_NORMAL = "uDeploy";
    public static final String PRODUCT_NAME_SIMPLE = "udeploy";
    public static final String CLI_SCRIPT_NAME = "udclient";
    public static final String AUTH_TOKEN_USERNAME = "PasswordIsAuthToken";
    private final String baseURL;
    private final String authToken;
    private final String username;
    private final String password;

    public static void main(String[] args) {
        int exitCode;
        block11: {
            Logger.getRootLogger().addAppender(new WriterAppender((Layout)new SimpleLayout(), System.out));
            Logger.getRootLogger().setLevel(Level.WARN);
            boolean verbose = true;
            try {
                CommandLineParser parser = new CommandLineParser();
                ParsedCommandLine parsedCommandLine = parser.parse(args, System.getenv());
                verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
                String authToken = null;
                String baseURL = parsedCommandLine.getOptionValue(OPTION_WEB_URL, null, ENV_WEB_URL, null, true);
                String authTokenOption = parsedCommandLine.getOptionValue(OPTION_AUTH_TOKEN, null, ENV_AUTH_TOKEN, null, false);
                String username = parsedCommandLine.getOptionValue(OPTION_USERNAME, null, ENV_USERNAME, null, false);
                String password = parsedCommandLine.getOptionValue(OPTION_PASSWORD, null, ENV_PASSWORD, null, false);
                if (authTokenOption != null) {
                    File specAuthTokenFile = new File(authTokenOption);
                    authToken = specAuthTokenFile.isFile() ? IO.readTextFile(specAuthTokenFile) : authTokenOption;
                    username = AUTH_TOKEN_USERNAME;
                    JSONObject tokenJson = new JSONObject();
                    tokenJson.put("token", authToken);
                    password = tokenJson.toString();
                } else {
                    File userHome = new File(System.getProperty("user.home"));
                    File uDeploy = new File(userHome, ".udeploy");
                    File authTokenFile = new File(uDeploy, "authToken");
                    if (authTokenFile.isFile()) {
                        authToken = IO.readTextFile(authTokenFile);
                    }
                    if (authToken != null) {
                        username = AUTH_TOKEN_USERNAME;
                        JSONObject tokenJson = new JSONObject();
                        while (authToken.endsWith("\n") || authToken.endsWith("\r")) {
                            authToken = authToken.substring(0, authToken.length() - 1);
                        }
                        tokenJson.put("token", authToken);
                        tokenJson.put("sysUser", System.getProperty("user.name"));
                        tokenJson.put("host", DeployCLI.getPrimaryIPv4());
                        password = tokenJson.toString();
                    }
                    if (username == null) {
                        System.out.println("Username not passed as command line property username or set in environment, DS_USERNAME");
                        username = System.console().readLine("Username : ", new Object[0]);
                    }
                    if (password == null) {
                        System.out.println("Password not passed as command line property password or set in environment, DS_PASSWORD");
                        password = String.valueOf(System.console().readPassword("Password : ", new Object[0]));
                    }
                }
                parsedCommandLine.setOptionValue(OPTION_USERNAME, username);
                parsedCommandLine.setOptionValue(OPTION_PASSWORD, password);
                parsedCommandLine.setOptionValue(OPTION_AUTH_TOKEN, null);
                DeployCLI main = new DeployCLI(baseURL, authToken, username, password);
                exitCode = main.execute(parsedCommandLine, System.out, System.err, System.in);
            }
            catch (MissingRequiredParameterException e) {
                exitCode = 1;
                System.out.println(e.toString());
            }
            catch (Exception e) {
                exitCode = 1;
                if (verbose) {
                    e.printStackTrace();
                }
                String msg = StringUtils.defaultIfEmpty(e.getMessage(), e.toString());
                System.out.println(msg);
                if (verbose) break block11;
                System.out.println(" Retry with --verbose flag for more info.");
            }
        }
        System.exit(exitCode);
    }

    private static String[] getAllIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (NetworkInterface interfaz : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inet : Collections.list(interfaz.getInetAddresses())) {
                    ips.add(inet.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        for (String ip : ips) {
            if (ip.startsWith("169.254") || ip.startsWith("fe80:")) continue;
            result.add(ip);
        }
        return result.toArray(new String[0]);
    }

    private static String[] getAllIPv4s() {
        String[] ips = DeployCLI.getAllIPs();
        ArrayList<String> result = new ArrayList<String>();
        for (String ip : ips) {
            if (ip.split("\\.").length != 4) continue;
            result.add(ip);
        }
        return result.toArray(new String[0]);
    }

    private static String getPrimaryIPv4() {
        String[] ips;
        String result = null;
        for (String ip : ips = DeployCLI.getAllIPv4s()) {
            if (ip.equals("localhost") || ip.equals("127.0.0.1")) continue;
            result = ip;
            break;
        }
        return result;
    }

    public DeployCLI(String baseURL, String authToken, String username, String password) {
        if (baseURL == null) {
            throw new IllegalArgumentException("'weburl' is a required parameter.");
        }
        this.baseURL = baseURL;
        this.authToken = authToken;
        this.username = username;
        this.password = password;
    }

    public int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, InputStream in) throws MissingRequiredParameterException, Exception {
        int exitCode;
        block26: {
            String commandName = parsedCommandLine.getCommandName();
            ClientConfigurationDownloader configDownloader = new ClientConfigurationDownloader();
            if ("logout".equals(commandName)) {
                try {
                    ClientConfiguration config = configDownloader.download(this.baseURL, this.authToken, this.username, this.password);
                    ClientCommand cmd = config.getCommandConfig(commandName);
                    if (parsedCommandLine.isPrintHelpAndExit()) {
                        exitCode = 0;
                        config.printHelp(out, parsedCommandLine.getCommandName());
                        break block26;
                    }
                    int responseCode = this.doLogout(parsedCommandLine, out, err, cmd);
                    if (responseCode >= 200 && responseCode < 300) {
                        exitCode = 0;
                        break block26;
                    }
                    exitCode = 1;
                }
                catch (Exception e) {
                    this.deleteAuthTokenFile();
                    exitCode = 0;
                }
            } else {
                ClientConfiguration config;
                try {
                    config = configDownloader.download(this.baseURL, this.authToken, this.username, this.password);
                }
                catch (SecurityException e) {
                    boolean deletedAuthToken = this.deleteAuthTokenFile();
                    if (deletedAuthToken) {
                        out.println("The existing session has been closed. Please log in again to re-establish it.");
                    }
                    throw e;
                }
                if (parsedCommandLine.isPrintHelpAndExit()) {
                    exitCode = 0;
                    config.printHelp(out, parsedCommandLine.getCommandName());
                } else {
                    ClientCommand cmd = config.getCommandConfig(commandName);
                    if (cmd == null) {
                        throw new UnknownCommandException("Unknown command: " + commandName);
                    }
                    if (parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_TEMPLATE)) {
                        if (cmd.getTemplate() != null) {
                            if (parsedCommandLine.getFileName() != null) {
                                FileOutputStream output = new FileOutputStream(parsedCommandLine.getFileName());
                                PrintStream fileOut = new PrintStream(output);
                                new JSONPrinter().print(cmd.getTemplate(), fileOut);
                                fileOut.println();
                                out.println("Template written to file " + parsedCommandLine.getFileName());
                            } else {
                                new JSONPrinter().print(cmd.getTemplate(), out);
                                out.println();
                            }
                        } else {
                            out.println("No template is available for the command " + cmd.getName());
                        }
                        exitCode = 0;
                    } else {
                        int responseCode = 0;
                        boolean standardCommand = true;
                        InputStream input = null;
                        if (commandName.equals("login")) {
                            standardCommand = false;
                            responseCode = this.doLogin(parsedCommandLine, err, cmd);
                        } else if (commandName.equals("addVersionFiles")) {
                            standardCommand = false;
                            responseCode = this.doAddVersionFiles(parsedCommandLine, out, err, cmd);
                        } else if (parsedCommandLine.getFileName() != null) {
                            input = new FileInputStream(parsedCommandLine.getFileName());
                        } else if (parsedCommandLine.isReadFromInputStream()) {
                            input = in;
                        }
                        if (standardCommand) {
                            responseCode = cmd.execute(parsedCommandLine, out, err, input);
                        }
                        exitCode = responseCode >= 200 && responseCode < 300 ? 0 : 1;
                    }
                }
            }
        }
        return exitCode;
    }

    private int doLogin(ParsedCommandLine parsedCommandLine, PrintStream err, ClientCommand cmd) throws Exception {
        int responseCode = 0;
        JSONObject tokenJson = new JSONObject();
        tokenJson.put("sysUser", System.getProperty("user.name"));
        tokenJson.put("host", DeployCLI.getPrimaryIPv4());
        String inputString = tokenJson.toString();
        ByteArrayInputStream loginInput = new ByteArrayInputStream(inputString.getBytes());
        File userHome = new File(System.getProperty("user.home"));
        File uDeploy = new File(userHome, ".udeploy");
        uDeploy.mkdirs();
        File authTokenFile = new File(uDeploy, "authToken");
        PrintStream pStream = new PrintStream(authTokenFile);
        responseCode = cmd.execute(parsedCommandLine, pStream, err, loginInput);
        pStream.close();
        Unix unix = new Unix();
        if (unix.isUnix()) {
            unix.chmod(authTokenFile, "go-wrx");
        }
        return responseCode;
    }

    private int doLogout(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, ClientCommand cmd) throws FileNotFoundException, Exception {
        int result = 0;
        if (this.username.equals(AUTH_TOKEN_USERNAME)) {
            ByteArrayInputStream logoutInput = new ByteArrayInputStream(this.password.getBytes());
            result = cmd.execute(parsedCommandLine, out, err, logoutInput);
        }
        this.deleteAuthTokenFile();
        return result;
    }

    private boolean deleteAuthTokenFile() {
        boolean result = false;
        File userHome = new File(System.getProperty("user.home"));
        File uDeploy = new File(userHome, ".udeploy");
        File authTokenFile = new File(uDeploy, "authToken");
        if (authTokenFile.exists()) {
            result = authTokenFile.delete();
        }
        return result;
    }

    private int doAddVersionFiles(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, ClientCommand cmd) throws Exception {
        int result = 200;
        ClientConfiguration config = cmd.getConfig();
        String baseUrl = parsedCommandLine.getOptionValue(config.getWebUrlOption());
        String authToken = parsedCommandLine.getOptionValue(config.getAuthTokenOption());
        String username = parsedCommandLine.getOptionValue(config.getUsernameOption());
        String password = parsedCommandLine.getOptionValue(config.getPasswordOption());
        String component = parsedCommandLine.getOptionValue("component", true);
        String version = parsedCommandLine.getOptionValue("version", true);
        String baseDir = parsedCommandLine.getOptionValue("base", true);
        String offset = parsedCommandLine.getOptionValue("offset", false);
        Set<String> includes = parsedCommandLine.getOptionValues("include", false);
        Set<String> excludes = parsedCommandLine.getOptionValues("exclude", false);
        boolean saveExecuteBits = Boolean.valueOf(parsedCommandLine.getOptionValue("saveExecuteBits", false));
        boolean verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
        File baseDirFile = new File(baseDir);
        if (!baseDirFile.isDirectory()) {
            throw new IllegalArgumentException("The given base directory is not a directory.");
        }
        if (includes == null) {
            includes = Collections.singleton("**/*");
        }
        if (excludes == null) {
            excludes = Collections.emptySet();
        }
        if (authToken == null) {
            authToken = this.authToken;
        }
        if (authToken == null && (username == null || password == null)) {
            throw new Exception("Invalid security options: Either " + config.getAuthTokenOption().getName() + " or " + config.getUsernameOption().getName() + " and " + config.getPasswordOption().getName() + " must be defined.");
        }
        AddVersionFilesCommand command = new AddVersionFilesCommand(baseUrl, username, password, authToken, component, version, baseDirFile, offset, includes.toArray(new String[includes.size()]), excludes.toArray(new String[excludes.size()]), saveExecuteBits, verbose);
        command.execute();
        return result;
    }
}

