/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class FlexibleSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory internalFactory;
    private final String[] supportedProtocols;

    FlexibleSSLSocketFactory(SSLSocketFactory internalFactory, String[] supportedProtocols) {
        this.internalFactory = internalFactory;
        ArrayList<String> enabledProtos = new ArrayList<String>(supportedProtocols.length);
        for (String proto : supportedProtocols) {
            if ("SSLv2Hello".equalsIgnoreCase(proto)) continue;
            enabledProtos.add(proto);
        }
        this.supportedProtocols = enabledProtos.toArray(new String[0]);
    }

    public Socket createSocket() throws IOException {
        Socket result = this.internalFactory.createSocket();
        if (result instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)result;
            sslSocket.setEnabledProtocols(this.supportedProtocols);
        }
        return result;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.internalFactory.createSocket(s, host, port, autoClose);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.internalFactory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.internalFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.internalFactory.createSocket(host, port, localHost, localPort);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.internalFactory.createSocket(address, port, localAddress, localPort);
    }

    public String[] getDefaultCipherSuites() {
        return this.internalFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.internalFactory.getSupportedCipherSuites();
    }
}

