/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactDownloadException;
import com.urbancode.ubuild.codestation.client.VfsClientFactory;
import com.urbancode.vfs.client.Client;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactDownloader
extends VfsClientFactory {
    private final Client client;

    ArtifactDownloader(Client client) {
        this.client = client;
    }

    List<File> downloadArtifacts(String repoId, String artifactSet, String[] includes, String[] excludes, File ... destinations) throws ArtifactDownloadException {
        ArrayList<File> artifacts = new ArrayList<File>();
        for (File destination : destinations) {
            try {
                String pathPrefix = null;
                if (this.isDownloadOfSpecificArtifacts(artifactSet)) {
                    pathPrefix = artifactSet;
                }
                artifacts.addAll(this.client.downloadLatestChangeSetFilesRemovingPrefix(repoId, destination, includes, excludes, pathPrefix));
            }
            catch (Exception e) {
                throw new ArtifactDownloadException("Unable to download artifacts of " + repoId + " to " + destination, e);
            }
        }
        return artifacts;
    }

    private boolean isDownloadOfSpecificArtifacts(String artifactSet) {
        return !StringUtil.isEmpty((String)artifactSet) && !".".equals(artifactSet);
    }
}

