/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.util;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.util.EncryptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

public class CodestationProperties {
    public static final String CODESTATION_USER_HOME_DIR_NAME = ".codestation";
    public static final String CODESTATION_CACHE_DIR_NAME = "cache";
    public static final String CODESTATION_REPO_DIR_NAME = "repo";
    public static final String CODESTATION_DEFAULT_PROPS_FILE_NAME = "codestation.properties";
    public static final String SERVER_PROPERTY = "codestation.server";
    public static final String USERNAME_PROPERTY = "codestation.user";
    public static final String PASSWORD_PROPERTY = "codestation.password";
    public static final String AUTH_TOKEN_PROPERTY = "codestation.authToken";
    public static final String L1_CACHE_PROPERTY = "codestation.cache.dir";
    public static final String L1_TIME_TO_LIVE = "codestation.cache.timeToLive";
    public static final String REPO_PROPERTY = "codestation.repo.dir";
    public static final String VERBOSE_PROPERTY = "codestation.verbose";
    public static final String ENV_WEB_URL = "WEB_URL";
    public static final String ENV_WEB_PROXY_HOST = "WEB_PROXY_HOST";
    public static final String ENV_WEB_PROXY_PORT = "WEB_PROXY_PORT";
    public static final String ENV_AUTH_TOKEN = "AUTH_TOKEN";
    public static final long DAY = 86400000L;
    private static final File DEFAULT_WORKING_DIR = new File(".");
    private static final long DEFAULT_TIME_TO_LIVE = 259200000L;
    private URI server;
    private AuthenticationCredentials credentials;
    private String authToken;
    private File localRepoDir;
    private File l1CacheDir;
    private File workingDir;
    private long l1TimeToLive;
    private boolean verbose;
    private final File defaultPropsFile;
    private final File defaultCacheDir;
    private final File defaultRepoDir;

    public CodestationProperties() {
        String userHome = System.getProperty("user.home");
        File csHomeDir = new File(userHome, CODESTATION_USER_HOME_DIR_NAME);
        this.defaultCacheDir = new File(csHomeDir, CODESTATION_CACHE_DIR_NAME);
        this.defaultRepoDir = new File(csHomeDir, CODESTATION_REPO_DIR_NAME);
        this.defaultPropsFile = new File(csHomeDir, CODESTATION_DEFAULT_PROPS_FILE_NAME);
    }

    public File getDefaultPropertiesFile() {
        return this.defaultPropsFile;
    }

    public void configure(Properties properties) {
        try {
            Properties defaultProps = this.readUserDefaultProperties();
            this.configure0(defaultProps);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configure0(this.readEnvironmentProperties());
        this.configure0(properties);
    }

    private void configure0(Properties properties) {
        if (properties != null) {
            String verboseStr;
            String authToken;
            String l1TimeToLiveStr;
            String l1CacheDirStr;
            String localRepoDirStr;
            String server = properties.getProperty(SERVER_PROPERTY);
            if (server != null) {
                server = server.trim();
                this.setServer(server);
            }
            String username = properties.getProperty(USERNAME_PROPERTY);
            String password = properties.getProperty(PASSWORD_PROPERTY);
            if (username != null && password != null) {
                if (EncryptionHandler.isEncrypted(password)) {
                    password = EncryptionHandler.decrypt(password);
                }
                AuthenticationCredentials credentials = AuthenticationCredentials.createUsernamePasswordCredentials(username, password);
                this.setCredentials(credentials);
            }
            if ((localRepoDirStr = properties.getProperty(REPO_PROPERTY)) != null) {
                File localRepoDir = new File(localRepoDirStr);
                this.setLocalRepoDir(localRepoDir);
            }
            if ((l1CacheDirStr = properties.getProperty(L1_CACHE_PROPERTY)) != null) {
                File l1CacheDir = new File(l1CacheDirStr);
                this.setL1CacheDir(l1CacheDir);
            }
            if ((l1TimeToLiveStr = properties.getProperty(L1_TIME_TO_LIVE)) != null) {
                try {
                    double l1TimeToLive = Double.valueOf(l1TimeToLiveStr);
                    this.setL1TimeToLive((long)(l1TimeToLive * 8.64E7));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((authToken = properties.getProperty(AUTH_TOKEN_PROPERTY)) != null) {
                AuthenticationCredentials credentials = AuthenticationCredentials.createAuthTokenCredentials(authToken);
                this.setCredentials(credentials);
            }
            if ((verboseStr = properties.getProperty(VERBOSE_PROPERTY)) != null) {
                boolean verbose = Boolean.valueOf(verboseStr);
                this.setVerbose(verbose);
            }
        }
    }

    protected Properties readEnvironmentProperties() {
        String proxyHost;
        String authToken;
        Properties result = new Properties();
        String webUrl = System.getenv(ENV_WEB_URL);
        if (webUrl != null) {
            result.setProperty(SERVER_PROPERTY, webUrl);
        }
        if ((authToken = System.getenv(ENV_AUTH_TOKEN)) != null) {
            result.setProperty(AUTH_TOKEN_PROPERTY, authToken);
        }
        if ((proxyHost = System.getenv(ENV_WEB_PROXY_HOST)) != null) {
            result.setProperty("http.proxyHost", proxyHost);
            String proxyPort = System.getenv(ENV_WEB_PROXY_PORT);
            if (proxyPort != null) {
                result.setProperty("http.proxyPort", proxyPort);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readUserDefaultProperties() throws IOException {
        Properties result = null;
        File defaultPropsFile = this.getDefaultPropertiesFile();
        if (defaultPropsFile != null && defaultPropsFile.exists() && defaultPropsFile.isFile()) {
            result = new Properties();
            FileInputStream in = new FileInputStream(defaultPropsFile);
            try {
                result.load(in);
            }
            finally {
                IO.close((InputStream)in);
            }
            String password = result.getProperty(PASSWORD_PROPERTY);
            if (password != null && !EncryptionHandler.isEncrypted(password)) {
                result.setProperty(PASSWORD_PROPERTY, EncryptionHandler.encrypt(password));
                try {
                    FileOutputStream output = new FileOutputStream(defaultPropsFile);
                    try {
                        result.store(output, null);
                    }
                    finally {
                        IO.close((OutputStream)output);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public void setCredentials(AuthenticationCredentials credentials) {
        this.credentials = credentials;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLocalRepoDir(File localRepoDir) {
        this.localRepoDir = localRepoDir;
    }

    public void setL1CacheDir(File l1CacheDir) {
        this.l1CacheDir = l1CacheDir;
    }

    public void setL1TimeToLive(long l1TimeToLive) {
        this.l1TimeToLive = l1TimeToLive;
    }

    public void setServer(String server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        URI uri = this.parseUri(server);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("uri is not absolute: " + server);
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("uri does not specify a scheme: " + server);
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("uri does not specify a host: " + server);
        }
        this.server = uri;
    }

    protected URI parseUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getServer() {
        return this.server.toString();
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public AuthenticationCredentials getCredentials() {
        return this.credentials;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String toString() {
        String NL = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("server: ").append(this.server).append(NL);
        sb.append("localRepoDir: ").append(this.localRepoDir).append(NL);
        sb.append("cacheDir: ").append(this.l1CacheDir).append(NL);
        sb.append("workingDir: ").append(this.workingDir).append(NL);
        sb.append("cacheTimeToLive: ").append(this.l1TimeToLive).append(NL);
        sb.append("verbose: ").append(this.verbose).append(NL);
        return sb.toString();
    }
}

