/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.ant;

import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class CodestationTask
extends Task {
    private String basedir;
    private String serverAddress;
    private String username;
    private String password;
    private String authToken;
    private AuthenticationCredentials credentials;

    public CodestationClient configureBaseClient() throws BuildException {
        if (this.basedir == null) {
            try {
                Project project = this.getProject();
                File dir = project.getBaseDir();
                this.basedir = dir.getCanonicalPath();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.basedir == null) {
            throw new BuildException("Required field basedir left blank");
        }
        if (this.serverAddress == null) {
            this.serverAddress = System.getenv("WEB_URL");
        }
        if (this.authToken != null) {
            this.credentials = AuthenticationCredentials.createAuthTokenCredentials(this.authToken);
        } else if (this.username != null) {
            this.credentials = AuthenticationCredentials.createUsernamePasswordCredentials(this.username, this.password);
        }
        CodestationClient client = new CodestationClient(this.serverAddress, this.credentials);
        this.log(client.toString(), 3);
        return client;
    }

    public void setServer(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthToken(String authToken) {
        if (authToken != null && authToken.length() > 0 && !authToken.startsWith("${")) {
            this.authToken = authToken;
        }
    }

    public void setBasedir(File basedir) throws IOException {
        this.basedir = basedir.getCanonicalPath();
    }

    protected void printVersionInfo() {
        String message = CodestationTask.class.getPackage().getImplementationVersion();
        this.log("Using CodeStation client version " + message);
    }
}

