/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.ClientPathEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

class AddVersionFilesCommand {
    private String baseUrl;
    private String authToken;
    private String component;
    private String version;
    private File base;
    private String offset;
    private String[] includes;
    private String[] excludes;
    private boolean saveExecuteBits;
    private boolean verbose;
    private HttpClient client;

    public AddVersionFilesCommand(String baseUrl, String user, String password, String authToken, String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose) {
        this.baseUrl = baseUrl.replaceAll("/+$", "");
        this.component = component;
        this.version = version;
        this.base = base;
        this.offset = offset;
        this.includes = includes;
        this.excludes = excludes;
        this.saveExecuteBits = saveExecuteBits;
        this.verbose = verbose;
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTrustAllCerts(true);
        if (user != null && password != null) {
            builder.setPreemptiveAuthentication(true);
            builder.setUsername(user);
            builder.setPassword(password);
        } else if (authToken != null) {
            this.authToken = authToken;
        }
        this.client = builder.buildClient();
        if (!StringUtils.isEmpty(this.offset)) {
            if (this.offset.startsWith("./") || this.offset.startsWith(".\\")) {
                this.offset = this.offset.substring(2);
            } else if (".".equals(this.offset)) {
                this.offset = this.offset.substring(1);
            }
        }
    }

    public void execute() throws Exception {
        ClientPathEntry[] entries = this.getEntries();
        String url = this.getUrl("/addVersionFilesFull", new Object[0]);
        HttpPost method = new HttpPost(url);
        this.addAuthToken(method);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("component", new StringBody(this.component));
        entity.addPart("version", new StringBody(this.version));
        HashSet<String> handledHashes = new HashSet<String>();
        for (ClientPathEntry entry : entries) {
            entity.addPart("entryMetadata", new StringBody(entry.toJSON().toString()));
            String path = entry.getPath();
            File file = new File(this.base, path.replaceAll("^[\\\\/]+", ""));
            if (file.isFile() && !handledHashes.contains(entry.getContentHash().getValue())) {
                entity.addPart("entryContent-" + entry.getContentHash().getValue(), new FileBody(file));
                handledHashes.add(entry.getContentHash().getValue());
            }
            if (!this.verbose) continue;
            System.out.println("Uploading file " + file.getPath());
        }
        method.setEntity(entity);
        try {
            this.execute(method);
        }
        catch (Exception e) {
            method = new HttpPost(url);
            method.setEntity(entity);
            try {
                this.execute(method);
            }
            catch (Exception e1) {
                method = new HttpPost(url);
                method.setEntity(entity);
                try {
                    this.execute(method);
                }
                catch (Exception e2) {
                    throw new RuntimeException(String.format("%s\n%s\n%s", e, e1, e2));
                }
            }
        }
    }

    private ClientPathEntry[] getEntries() throws Exception {
        FileListerBuilder.Permissions permissions = FileListerBuilder.Permissions.NONE;
        if (this.saveExecuteBits) {
            permissions = FileListerBuilder.Permissions.FILE_EXECUTE_ONLY;
        }
        return ClientPathEntry.createPathEntriesFromFileSystemWithPrefix(this.base, this.includes, this.excludes, this.offset, FileListerBuilder.Directories.INCLUDE_ALL, permissions, FileListerBuilder.Symlinks.EXCLUDE, "SHA-256");
    }

    private String getUrl(String path, Object ... parameters) throws Exception {
        this.baseUrl = this.baseUrl.replaceAll("/+$", "");
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseUrl);
        sb.append("/cli-internal/version");
        sb.append(path);
        if (parameters != null && parameters.length > 0) {
            sb.append('?');
            sb.append(URLEncoder.encode(parameters[0].toString(), "UTF-8"));
            sb.append('=');
            sb.append(URLEncoder.encode(parameters[1].toString(), "UTF-8"));
            for (int i = 2; i < parameters.length; i += 2) {
                sb.append('&');
                sb.append(URLEncoder.encode(parameters[i].toString(), "UTF-8"));
                sb.append('=');
                sb.append(URLEncoder.encode(parameters[i + 1].toString(), "UTF-8"));
            }
        }
        return sb.toString();
    }

    private void addAuthToken(HttpRequestBase method) throws Exception {
        if (this.authToken != null) {
            method.setHeader("Authorization-Token", this.authToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(HttpRequestBase method) throws Exception {
        String result;
        HttpResponse response = this.client.execute(method);
        int code = response.getStatusLine().getStatusCode();
        try {
            if (code < 200 || code >= 300) {
                String message = this.readResponse(response);
                throw new Exception("Request error: " + code + ": " + message);
            }
            result = this.readResponse(response);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpResponse response) throws IOException {
        InputStream in;
        String result = null;
        if (response.getEntity() != null && (in = response.getEntity().getContent()) != null) {
            try {
                result = IO.readText(in, IO.utf8());
            }
            finally {
                in.close();
            }
        }
        return result;
    }
}

