/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.ds.client.ClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.xml.sax.SAXException;

class ClientConfigurationDownloader {
    ClientConfigurationDownloader() {
    }

    ClientConfiguration download(String baseURL, String authToken, String username, String password) throws SecurityException, IOException {
        ClientConfiguration configuration;
        boolean useAuthToken;
        if (authToken == null && (username == null || password == null)) {
            throw new SecurityException("Invalid security options: Either authentication token or username and password must be defined.");
        }
        String url = baseURL + (baseURL.endsWith("/") ? "cli/application.wadl" : "/cli/application.wadl");
        HttpGet getMethod = new HttpGet(url);
        boolean bl = useAuthToken = authToken != null && username == null && password == null;
        if (useAuthToken) {
            getMethod.setHeader("Authorization-Token", authToken);
        }
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTrustAllCerts(true);
        if (username != null && password != null) {
            builder.setUsername(username);
            builder.setPassword(password);
            builder.setPreemptiveAuthentication(true);
        }
        DefaultHttpClient client = builder.buildClient();
        try {
            HttpResponse response = client.execute(getMethod);
            int responseCode = response.getStatusLine().getStatusCode();
            if (!this.isGoodResponseCode(responseCode)) {
                if (responseCode == 401) {
                    throw new SecurityException("Authentication failure while getting configuration from the server at " + url + ".");
                }
                throw new IOException("Error downloading the configuration from the server at " + url + ". Response code " + responseCode);
            }
            InputStream responseStream = response.getEntity().getContent();
            configuration = new ClientConfiguration(responseStream);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not parse the configuration downloaded from the server at " + url + ". " + e.toString(), e);
        }
        catch (SAXException e) {
            throw new IOException("Could not parse the configuration downloaded from the server at " + url + ". " + e.toString(), e);
        }
        catch (Exception e) {
            throw new IOException(this.getMessageForException(e, url), e);
        }
        return configuration;
    }

    private String getMessageForException(Exception e, String url) {
        String msg = "Error downloading the configuration from the server at %s due to %s. ";
        String result = String.format(msg, url, e.getClass().getSimpleName());
        if (e instanceof SSLHandshakeException) {
            result = result + " Commonly this is the result of using https:// against the server's http port.";
        } else if (e instanceof java.net.ProtocolException || e instanceof ProtocolException) {
            result = result + " Commonly this is the result of using http:// against the server's https port.";
        } else if (e instanceof NoRouteToHostException) {
            result = result + " Commonly this is the result of being on a different network from the server or the server is down.";
        } else if (e instanceof ConnectException) {
            result = result + " Commonly this is the result of having the wrong port in the url.";
        } else if (e instanceof UnknownHostException) {
            result = result + " Commonly this is the result of having the wrong hostname in the url.";
        }
        return result;
    }

    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
}

