import com.urbancode.air.*;
import com.urbancode.air.plugin.automation.*;
import org.codehaus.jettison.json.JSONObject;

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile
final def javaHome = System.getenv('JAVA_HOME')
final def webUrl = System.getenv('WEB_URL')
final def authToken = System.getenv('AUTH_TOKEN')
final def buildLifeId = System.getenv('BUILD_LIFE_ID')
final def pluginHome = System.getenv("PLUGIN_HOME");

final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def stepProps = apTool.getStepProperties();
final def CommandHelper cmdHelper = new CommandHelper(workDir);

final def javaFile = new File(new File(javaHome), 'bin/java' + (apTool.isWindows ? '.exe' : ''))
final def udClientJarFile = new File(new File(pluginHome), 'lib/udeploy-client.jar')

def url = stepProps['automation/url'];
def user = stepProps['automation/user'];
def ucdAuthToken = stepProps['automation/authToken']
def password = stepProps['automation/passScript']?.trim() ?: stepProps['automation/password'];
def componentName = stepProps['componentName'];
def versionName = stepProps['versionName'];
def includes = stepProps['includes'];
def excludes = stepProps['excludes'];

cmdArgs = [javaFile.absolutePath, '-jar', udClientJarFile.absolutePath,
           "--weburl", url,
           "addVersionFiles", 
           "--component", componentName,
           "--version", versionName,
           "--base", workDir.absolutePath,
           "--verbose"];

       if (ucdAuthToken) {
    cmdArgs << "--authtoken" << ucdAuthToken
}
else {
    cmdArgs << "--username" << user << "--password" << password
}

if (includes) {
    includes.split("\\n").each { include ->
        cmdArgs << "--include" << include
    }
}

if (excludes) {
    excludes.split("\\n").each { exclude ->
        cmdArgs << "--exclude" << exclude
    }
}

println "Publishing files for version ${versionName} on component ${componentName}"
cmdHelper.runCommand("Publish IBM UrbanCode Deploy Component Version Files", cmdArgs) { proc ->
    def out = new StringBuffer()
    def err = new StringBuffer()
    proc.out.close() // close stdin
    proc.waitForProcessOutput(out, err)
    commandOutput = err.toString().trim()
}
if (commandOutput.contains("Request error")) {
    println commandOutput
    System.exit(1);
}
println "Success"
