/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.StringUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@BridgeMethodsAdded
public class SSLContextProtocolDetector {
    private static final Logger log = Logger.getLogger(SSLContextProtocolDetector.class);
    public static final String SSL_CONTEXT_PROTOCOL = "com.urbancode.commons.util.ssl.sslContextProtocol";
    public static final String SSL_CONTEXT_ENABLED_PROTOCOLS = "com.urbancode.commons.util.ssl.sslContextEnabledProtocols";
    private static final String[] sslContextProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] suggestedCipherSuites = new String[]{"TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "SSL_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "SSL_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "SSL_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "SSL_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "SSL_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "SSL_RSA_WITH_AES_256_CBC_SHA256"};

    private static final String[] parseProtocolsProperty() {
        String[] result = null;
        String systemProperty = System.getProperty(SSL_CONTEXT_ENABLED_PROTOCOLS);
        if (!StringUtil.isEmpty(systemProperty)) {
            result = StringUtils.split(systemProperty, ',');
        }
        return result;
    }

    public static String detectSslContextProtocol() {
        String result = System.getProperty(SSL_CONTEXT_PROTOCOL);
        if (result == null) {
            for (String protocol : sslContextProtocols) {
                try {
                    SSLContext.getInstance(protocol);
                    result = protocol;
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                }
            }
        }
        return result;
    }

    public static String[] getSuggestedCipherSuites() {
        return (String[])suggestedCipherSuites.clone();
    }

    public static String[] getSupportedCipherSuites() {
        HashSet<String> supportedCipherSuites = new HashSet<String>();
        try {
            SSLContext context = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            context.init(null, null, null);
            for (String cipher : context.getSocketFactory().getSupportedCipherSuites()) {
                supportedCipherSuites.add(cipher.toUpperCase());
            }
        }
        catch (NoSuchAlgorithmException e) {
            return (String[])suggestedCipherSuites.clone();
        }
        catch (KeyManagementException e) {
            return (String[])suggestedCipherSuites.clone();
        }
        ArrayList<String> result = new ArrayList<String>(suggestedCipherSuites.length);
        for (String cipher : suggestedCipherSuites) {
            if (!supportedCipherSuites.contains(cipher.toUpperCase())) continue;
            result.add(cipher);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getPossibleSslContextProtocols() {
        return (String[])sslContextProtocols.clone();
    }

    public static String[] getSupportedSslContextProtocols() {
        HashSet<String> result = new HashSet<String>();
        String[] protocolsToEnable = sslContextProtocols;
        String[] userSpecifiedProtocols = SSLContextProtocolDetector.parseProtocolsProperty();
        if (userSpecifiedProtocols != null) {
            protocolsToEnable = userSpecifiedProtocols;
        }
        boolean helloAdded = false;
        for (String protocol : protocolsToEnable) {
            try {
                SSLContext context = SSLContext.getInstance(protocol);
                result.add(protocol);
                if (helloAdded) continue;
                context.init(null, null, null);
                List<String> supportedProtocols = Arrays.asList(context.createSSLEngine().getSupportedProtocols());
                if (!supportedProtocols.contains("SSLv2Hello")) continue;
                result.add("SSLv2Hello");
                helloAdded = true;
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (KeyManagementException e) {
                log.error("Unable to initialize SSLContext for protocol " + protocol + ".", e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private SSLContextProtocolDetector() {
    }
}

