/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*
import org.codehaus.jettison.json.JSONArray
import org.codehaus.jettison.json.JSONObject
import javax.ws.rs.core.UriBuilder

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile
final def javaHome = System.getenv('JAVA_HOME')
final def webUrl = System.getenv('WEB_URL')
final def authToken = System.getenv('AUTH_TOKEN')
final def buildLifeId = System.getenv('BUILD_LIFE_ID')
final def pluginHome = System.getenv("PLUGIN_HOME")

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def stepProps = apTool.getStepProperties()
final def CommandHelper cmdHelper = new CommandHelper(workDir)

final def javaFile = new File(new File(javaHome), 'bin/java' + (apTool.isWindows ? '.exe' : ''))
final def udClientJarFile = new File(new File(pluginHome), 'lib/udclient.jar')

def url = stepProps['automation/url']
def user = stepProps['automation/user']
def ucdAuthToken = stepProps['automation/authToken']
def password = stepProps['automation/passScript'] ?: stepProps['automation/password']
def componentName = stepProps['componentName']
def versionName = stepProps['versionName']
def propertiesTextArea = stepProps['propertiesTextArea']

def httpHelper = new HttpHelper()
if (ucdAuthToken) {
    JSONObject tokenJson = new JSONObject();
    tokenJson.put("token", ucdAuthToken);
    user = "PasswordIsAuthToken"
    password = tokenJson.toString()
}

if (user && password) {
    httpHelper.setUsernameAndPassword(user, password)
}

def propsHelper = new PropsHelper(httpHelper)
propsHelper.setComponentVersionProperties(url, componentName, versionName, propertiesTextArea)
