/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.ds.client.ClientCommand;
import com.urbancode.ds.client.ClientCommandFlag;
import com.urbancode.ds.client.ClientCommandOption;
import com.urbancode.ds.client.ConsoleSize;
import com.urbancode.ds.client.HelpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ClientConfiguration {
    public static final ClientCommandOption OPTION_WEB_URL = new ClientCommandOption("weburl", "weburl", "DS_WEB_URL", "The base URL of the IBM UrbanCode Deploy server. Eg. http://ibm-ucd.domain.com:8080", true, null, null);
    public static final ClientCommandOption OPTION_AUTH_TOKEN = new ClientCommandOption("authtoken", "authtoken", "DS_AUTH_TOKEN", "An authentication token generated by the server. Either an authtoken or a username and password is required ", false, null, null);
    public static final ClientCommandOption OPTION_USERNAME = new ClientCommandOption("username", "username", "DS_USERNAME", "A username to authenticate with the server. Either an authtoken or a username and password is required ", false, null, null);
    public static final ClientCommandOption OPTION_PASSWORD = new ClientCommandOption("password", "password", "DS_PASSWORD", "A password to authenticate with the server. Either an authtoken or a username and password is required ", false, null, null);
    public static final ClientCommandOption OPTION_PROXY_USER = new ClientCommandOption("proxyUser", "proxyUser", "proxyUser", "A username to authenticate with the proxy.", false, null, null);
    public static final ClientCommandOption OPTION_PROXY_PASS = new ClientCommandOption("proxyPassword", "proxyPassword", "proxyPassword", "A password to authenticate with the proxy.", false, null, null);
    public static final ClientCommandOption OPTION_PROXY_HOST = new ClientCommandOption("proxyHost", "proxyHost", "proxyHost", "The hostname of a proxy (e.g., an agent relay) to use instead of directly connecting to the server", false, null, null);
    public static final ClientCommandOption OPTION_PROXY_PORT = new ClientCommandOption("proxyPort", "proxyPort", "proxyPort", "The proxy port to use if a proxy hostname has been specified", false, null, null);
    public static final ClientCommandOption OPTION_LOGGING_CONF = new ClientCommandOption("loggingConf", "loggingConf", "loggingConf", "A properties file for custom log4j configuration. Overrides debug and debugHttp flags.", false, null, null);
    public static final ClientCommandFlag FLAG_HELP = new ClientCommandFlag("help", "h", "Print the full description and help of the given command instead of running the command.");
    public static final ClientCommandFlag FLAG_VERBOSE = new ClientCommandFlag("verbose", "v", "Print extra information during execution.");
    public static final ClientCommandFlag FLAG_DEBUG = new ClientCommandFlag("debug", null, "Print debugging information during execution. Implies verbose.");
    public static final ClientCommandFlag FLAG_DEBUG_HTTP = new ClientCommandFlag("debugHttp", null, "Print detailed HTTP debugging information during execution.");
    public static final ClientCommandFlag FLAG_TEMPLATE = new ClientCommandFlag("getTemplate", "t", "Show the JSON template for the command instead of running the command. If a file argument is provided, the template will be output to that file.");
    public static final ClientCommandFlag[] globalFlagList = new ClientCommandFlag[]{FLAG_TEMPLATE, FLAG_HELP, FLAG_VERBOSE, FLAG_DEBUG, FLAG_DEBUG_HTTP};
    private Map<String, ClientCommand> cmdMap = new HashMap<String, ClientCommand>();
    private Map<String, ClientCommand> aliasMap = new HashMap<String, ClientCommand>();
    private Map<String, ClientCommandOption> globalOptMap = new HashMap<String, ClientCommandOption>();

    public static ClientCommandFlag getFlag(String name) {
        ClientCommandFlag result = null;
        for (ClientCommandFlag flag : globalFlagList) {
            if (flag.getName().equals(name)) {
                result = flag;
                break;
            }
            if (StringUtil.isEmpty(flag.getShortName()) || !flag.getShortName().equals(name)) continue;
            result = flag;
            break;
        }
        return result;
    }

    public ClientConfiguration(InputStream input) throws IOException, ParserConfigurationException, SAXException {
        this.globalOptMap.put("weburl", OPTION_WEB_URL);
        this.globalOptMap.put("authtoken", OPTION_AUTH_TOKEN);
        this.globalOptMap.put("username", OPTION_USERNAME);
        this.globalOptMap.put("password", OPTION_PASSWORD);
        this.globalOptMap.put("proxyHost", OPTION_PROXY_HOST);
        this.globalOptMap.put("proxyPort", OPTION_PROXY_PORT);
        this.globalOptMap.put("proxyUser", OPTION_PROXY_USER);
        this.globalOptMap.put("proxyPassword", OPTION_PROXY_PASS);
        this.globalOptMap.put("loggingConf", OPTION_LOGGING_CONF);
        if (input != null) {
            Document doc = DOMUtils.loadDocument(input);
            Element docElement = doc.getDocumentElement();
            Element resourcesElement = DOMUtils.getFirstChild(docElement, "resources");
            this.buildCommandMap("", new ClientCommandOption[0], resourcesElement);
        }
    }

    public ClientCommand getCommandConfig(String cmdName) {
        ClientCommand cmd = this.cmdMap.get(cmdName);
        if (cmd == null) {
            cmd = this.aliasMap.get(cmdName);
        }
        return cmd;
    }

    public String[] getCommandNames() {
        Object[] cmdNames = this.cmdMap.keySet().toArray(new String[0]);
        Arrays.sort(cmdNames);
        return cmdNames;
    }

    public ClientCommandOption getGlobalOption(String optName) {
        return this.globalOptMap.get(optName);
    }

    public String[] getGlobalOptionNames() {
        Object[] cmdNames = this.globalOptMap.keySet().toArray(new String[0]);
        Arrays.sort(cmdNames);
        return cmdNames;
    }

    public ClientCommandOption getWebUrlOption() {
        return OPTION_WEB_URL;
    }

    public ClientCommandOption getAuthTokenOption() {
        return OPTION_AUTH_TOKEN;
    }

    public ClientCommandOption getUsernameOption() {
        return OPTION_USERNAME;
    }

    public ClientCommandOption getPasswordOption() {
        return OPTION_PASSWORD;
    }

    public ClientCommandOption getProxyHostOption() {
        return OPTION_PROXY_HOST;
    }

    public ClientCommandOption getProxyPortOption() {
        return OPTION_PROXY_PORT;
    }

    public ClientCommandOption getProxyUserOption() {
        return OPTION_PROXY_USER;
    }

    public ClientCommandOption getProxyPasswordOption() {
        return OPTION_PROXY_PASS;
    }

    public String toHelp() {
        String LS = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Global Args:").append(LS).append(LS);
        for (String optName : this.getGlobalOptionNames()) {
            ClientCommandOption opt = this.getGlobalOption(optName);
            sb.append(opt.toHelp()).append(LS);
        }
        sb.append("Global Flags:").append(LS).append(LS);
        for (ClientCommandFlag flag : globalFlagList) {
            sb.append(flag.toHelp()).append(LS);
        }
        sb.append("Commands:").append(LS);
        if (this.cmdMap.isEmpty()) {
            sb.append("\n");
            sb.append("         Provide a web URL, username, and password to show all available commands.\n");
        } else {
            String[] commandNames = this.getCommandNames();
            int numCommands = commandNames.length;
            int maxNameLength = 0;
            for (String cmdName : commandNames) {
                maxNameLength = Math.max(maxNameLength, cmdName.length());
            }
            int columns = new ConsoleSize().getColumns();
            String indent = "      ";
            int availableSpace = columns - indent.length();
            int commandsPerRow = availableSpace / (maxNameLength + 1);
            for (int i = 0; i < numCommands; ++i) {
                if (i % commandsPerRow == 0) {
                    sb.append(LS);
                    sb.append(indent);
                }
                sb.append(String.format("%-" + (maxNameLength + 1) + "s", commandNames[i]));
            }
        }
        return sb.toString();
    }

    public void printHelp(PrintStream ps, String cmdName) {
        String LS = System.getProperty("line.separator");
        int columns = new ConsoleSize().getColumns();
        ClientCommand cmd = null;
        if (cmdName != null) {
            cmd = this.getCommandConfig(cmdName);
        }
        StringBuilder sb = new StringBuilder();
        String indent = "      ";
        if (cmd != null) {
            boolean usesTemplateFile = cmd.getTemplate() != null;
            sb.append("NAME ").append(LS);
            sb.append(indent);
            String nameLine = cmd.getName();
            if (!StringUtils.isEmpty(cmd.getSummary())) {
                nameLine = nameLine + " - " + cmd.getSummary();
            }
            HelpUtil.manageLineWrapping(sb, nameLine, indent.length(), columns);
            if (!StringUtils.isEmpty(cmd.getDescription())) {
                sb.append(LS).append(indent);
                HelpUtil.manageLineWrapping(sb, cmd.getDescription(), indent.length(), columns);
            }
            if (ArrayUtils.isNotEmpty(cmd.getAliases())) {
                String prefix = indent + "alias: ";
                sb.append(prefix);
                HelpUtil.manageLineWrapping(sb, StringUtils.join((Object[])cmd.getAliases(), ", "), prefix.length(), columns);
            }
            sb.append(LS);
            if (usesTemplateFile) {
                sb.append(indent);
                HelpUtil.manageLineWrapping(sb, "This command takes a JSON request body. Use the -t flag to view the template for the data required for this command.", indent.length(), columns);
            }
            sb.append(LS);
            sb.append("SYNOPSIS").append(LS);
            sb.append(indent).append("udclient [global-args...] [global-flags...] ").append(cmd.getName()).append(" [args...]");
            if (usesTemplateFile) {
                sb.append(" [-] [filename]");
            }
            sb.append(LS);
            if (usesTemplateFile) {
                sb.append(LS);
                sb.append(indent).append("-").append(LS);
                sb.append(indent).append("   ");
                HelpUtil.manageLineWrapping(sb, "Read JSON input from the stdin. See command for requirements.", indent.length() + 3, columns);
                sb.append(LS);
                sb.append(indent).append("filename").append(LS);
                sb.append(indent).append("   ");
                HelpUtil.manageLineWrapping(sb, "Read JSON input from a file with the given filename. See command for requirements.", indent.length() + 3, columns);
            }
            sb.append(LS);
            sb.append("OPTIONS:").append(LS);
            sb.append(LS);
            if (cmd.getOptions().length == 0) {
                sb.append("         No options for this command.").append(LS);
            } else {
                for (ClientCommandOption opt : cmd.getOptions()) {
                    sb.append(opt.toHelp());
                    sb.append(LS);
                }
            }
        } else {
            sb.append("NAME ").append(LS);
            sb.append(indent);
            HelpUtil.manageLineWrapping(sb, "udclient - command line client for IBM UrbanCode Deploy", indent.length(), columns);
            sb.append(LS);
            sb.append("SYNOPSIS").append(LS);
            sb.append(indent).append("udclient [global-args...] [global-flags...] <command> [args...]").append(LS);
            sb.append(LS);
            sb.append(indent).append("   command").append(LS);
            sb.append(indent).append("      ");
            HelpUtil.manageLineWrapping(sb, "One of the named commands below in the Commands section", indent.length() + 6, columns);
            sb.append(LS);
            sb.append(this.toHelp());
        }
        ps.println(sb.toString());
    }

    private void buildCommandMap(String base, ClientCommandOption[] options, Element element) {
        ArrayList<ClientCommandOption> optionList = new ArrayList<ClientCommandOption>();
        for (ClientCommandOption givenOption : options) {
            optionList.add(givenOption);
        }
        List<Element> paramElements = DOMUtils.getChildElementList(element, "param");
        for (Element paramElement : paramElements) {
            optionList.add(ClientCommandOption.fromXML(paramElement));
        }
        String elementPath = element.getAttribute("path");
        String newBase = base;
        if (elementPath.length() > 0 && newBase.length() > 0 && !newBase.endsWith("/") && !elementPath.startsWith("/")) {
            newBase = newBase + "/";
        }
        newBase = newBase + elementPath;
        List<Element> methodElements = DOMUtils.getChildElementList(element, "method");
        for (Element methodElement : methodElements) {
            String method = methodElement.getAttribute("name");
            String id = methodElement.getAttribute("id");
            String mediaType = "application/json";
            Element responseElement = DOMUtils.getFirstChild(methodElement, "response");
            if (responseElement != null) {
                Element representationElement = DOMUtils.getFirstChild(responseElement, "representation");
                mediaType = representationElement.getAttribute("mediaType");
            }
            String summary = null;
            String description = null;
            JSONObject template = null;
            Element docElement = DOMUtils.getFirstChild(methodElement, "doc");
            if (docElement != null) {
                Element templateElement;
                Element descriptionElement;
                Element summaryElement = DOMUtils.getFirstChild(docElement, "summary");
                if (summaryElement != null) {
                    summary = summaryElement.getTextContent();
                }
                if ((descriptionElement = DOMUtils.getFirstChild(docElement, "description")) != null) {
                    description = descriptionElement.getTextContent();
                }
                if ((templateElement = DOMUtils.getFirstChild(docElement, "template")) != null) {
                    String templateText = templateElement.getTextContent();
                    try {
                        template = new JSONObject(templateText);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Could not convert template text for command " + id + ": " + templateText);
                    }
                }
            }
            ClientCommand command = new ClientCommand(this, id, new String[0], summary, description, method, mediaType, newBase, template);
            for (ClientCommandOption option : optionList) {
                command.addOption(option);
            }
            Element requestElement = DOMUtils.getFirstChild(methodElement, "request");
            if (requestElement != null) {
                List<Element> queryParamElements = DOMUtils.getChildElementList(requestElement, "param");
                for (Element queryParamElement : queryParamElements) {
                    command.addOption(ClientCommandOption.fromXML(queryParamElement));
                }
            }
            this.cmdMap.put(id, command);
        }
        ClientCommandOption[] optionArray = optionList.toArray(new ClientCommandOption[0]);
        List<Element> childResources = DOMUtils.getChildElementList(element, "resource");
        for (Element child : childResources) {
            this.buildCommandMap(newBase, optionArray, child);
        }
    }
}

