/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.listener;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JspCompileOnStartupListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(JspCompileOnStartupListener.class);
    private ServletContext servletContext;
    private volatile Thread compileThread;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        this.compileThread = new Thread("jsp_precompile"){

            public void run() {
                JspCompileOnStartupListener.this.compileJspsInDirectory("/");
                JspCompileOnStartupListener.this.compileThread = null;
            }
        };
        this.compileThread.setPriority(1);
        this.compileThread.setDaemon(true);
        this.compileThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                log.warn((Object)("Exception in jsp pre-compilation thread " + e), e);
                JspCompileOnStartupListener.this.compileThread = null;
            }
        });
        this.compileThread.start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Thread cmpThread = this.compileThread;
        if (cmpThread != null && cmpThread.isAlive()) {
            cmpThread.interrupt();
        }
    }

    private void compileJspsInDirectory(String dirPath) {
        HttpServletRequest request = this.createHttpServletRequest();
        HttpServletResponse response = this.createHttpServletResponse();
        log.info((Object)("Compiling jsps for " + this.servletContext.getContextPath() + dirPath));
        this.compileJspsInDirectory(dirPath, request, response);
        log.info((Object)("Compiling jsps completed for " + this.servletContext.getContextPath() + dirPath));
    }

    private void compileJspsInDirectory(String dirPath, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<String> pathsToCompile = new ArrayList<String>();
        pathsToCompile.add(dirPath);
        while (!pathsToCompile.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                log.error((Object)"jsp compile interrupted error, halting");
                this.servletContext.log("jsp compile interrupted error, halting");
                break;
            }
            String path = (String)pathsToCompile.remove(pathsToCompile.size() - 1);
            if (path.endsWith(".jsp")) {
                RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    throw new Error(path + " not found");
                }
                try {
                    log.debug((Object)("Compiling " + path));
                    this.servletContext.log("Compiling " + path);
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception e) {
                    log.error((Object)("compile error " + path), (Throwable)e);
                    this.servletContext.log("include", (Throwable)e);
                }
                continue;
            }
            if (!path.endsWith("/")) continue;
            Set childPaths = this.servletContext.getResourcePaths(path);
            pathsToCompile.addAll(childPaths);
        }
    }

    private HttpServletRequest createHttpServletRequest() {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("getQueryString")) {
                    return "jsp_precompile=true";
                }
                if (methodName.equals("isAsyncSupported")) {
                    return false;
                }
                if (methodName.equals("isAsyncStarted")) {
                    return false;
                }
                return null;
            }
        };
        return (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, handler);
    }

    private HttpServletResponse createHttpServletResponse() {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
        return (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, handler);
    }
}

