<%--
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Build
- IBM UrbanCode Deploy
- IBM UrbanCode Release
- IBM AnthillPro
- (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"     required="true"%>
<%@attribute name="list"     required="true"  type="java.lang.Object"%>
<%@attribute name="selectedZone" required="false" type="java.util.TimeZone" %>
<%@attribute name="canUnselect" required="false" type="java.lang.Boolean" %>
<%@attribute name="enabled"  required="false" type="java.lang.Boolean"%>


<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<c:set var="enabled" value="${empty enabled || enabled}"/>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</b>
  </c:when>
  
  <c:otherwise>
    <select name="${name}" <c:if test="${!enabled}">disabled="disabled"</c:if> >
      <c:choose>
        <c:when test="${canUnselect}">
          <option value="">-- None --</option>
        </c:when>
        <c:otherwise>
          <option value="">-- Make Selection --</option>
        </c:otherwise>
      </c:choose>
      
      <c:forEach var="item" items="${list}">
        <option value="${fn:escapeXml(item.ID)}" <c:if test="${item.ID == selectedZone.ID}">selected="selected"</c:if> >
          <fmt:formatNumber type='number' pattern="+00.0;-00.0">${item.rawOffset div (60*60*1000)}</fmt:formatNumber> &nbsp;&nbsp; ${fn:escapeXml(item.ID)}
        </option>
      </c:forEach>
    </select>
  </c:otherwise>
</c:choose>
