/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.web.util.FormErrors;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class Form {
    public static String get(HttpServletRequest request, String param) {
        String value = request.getParameter(param);
        return StringUtils.trimToNull((String)value);
    }

    public static String[] getValues(HttpServletRequest request, String param) {
        return request.getParameterValues(param);
    }

    public static boolean isClicked(HttpServletRequest request, String param) {
        return Form.get(request, param) != null;
    }

    public static boolean isSelected(HttpServletRequest request, String param) {
        return Form.get(request, param) != null;
    }

    public static Long getId(HttpServletRequest request, String param) {
        return Form.getLong(request, param);
    }

    public static Long[] getIds(HttpServletRequest request, String param) {
        String[] idstrings = request.getParameterValues(param);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (idstrings != null) {
            for (String i : idstrings) {
                if (i == null) continue;
                try {
                    ids.add(new Long(i));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        Long[] idsArray = new Long[ids.size()];
        ids.toArray(idsArray);
        return idsArray;
    }

    public static Integer getIndex(HttpServletRequest request, String param) {
        return Form.getInteger(request, param);
    }

    public static Integer getInteger(HttpServletRequest request, String param) {
        Integer result = null;
        String value = Form.get(request, param);
        if (value != null) {
            try {
                result = new Integer(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static Long getLong(HttpServletRequest request, String param) {
        Long result = null;
        String value = Form.get(request, param);
        if (value != null) {
            try {
                result = new Long(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static UUID getUUID(HttpServletRequest request, String param) {
        UUID result = null;
        String value = Form.get(request, param);
        if (value != null) {
            try {
                result = UUID.fromString(value);
            }
            catch (IllegalArgumentException swallow) {
                // empty catch block
            }
        }
        return result;
    }

    public static Double getDouble(HttpServletRequest request, String param) {
        Double result = null;
        String value = Form.get(request, param);
        if (value != null) {
            try {
                result = new Double(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getString(HttpServletRequest request, String param) {
        String value = request.getParameter(param);
        return StringUtils.trimToNull((String)value);
    }

    public static String getEmail(HttpServletRequest request, String param, FormErrors errors) {
        String value = request.getParameter(param);
        if (!Form.validateEmail(value = StringUtils.trimToNull((String)value))) {
            errors.addFieldError(param, "Invalid email address");
        }
        return value;
    }

    private static boolean validateEmail(String email) {
        if (email == null || email.length() == 0) {
            return true;
        }
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static String[] getStringValues(HttpServletRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = StringUtils.trimToNull((String)values[i]);
            }
        }
        return values;
    }

    public static String[] getStringValuesStartingWith(HttpServletRequest request, String prefix) {
        ArrayList<String> valueList = new ArrayList<String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(prefix)) continue;
            String paramValue = Form.getString(request, paramName);
            valueList.add(paramValue);
        }
        return valueList.toArray(new String[0]);
    }

    public static String[] getStringArray(HttpServletRequest request, String param) {
        String[] array = null;
        String value = Form.getString(request, param);
        if (value != null) {
            array = value.split("\r\n|\n|\r");
            ArrayList<String> finalList = new ArrayList<String>(Arrays.asList(array));
            ListIterator<String> itr = finalList.listIterator();
            while (itr.hasNext()) {
                String next = ((String)itr.next()).trim();
                if (next.length() == 0) {
                    itr.remove();
                    continue;
                }
                itr.set(next);
            }
            array = new String[finalList.size()];
            finalList.toArray(array);
        }
        return array;
    }

    public static boolean getBoolean(HttpServletRequest request, String paramName) {
        boolean result = false;
        String value = Form.get(request, paramName);
        if ("1".equals(value) || "yes".equalsIgnoreCase(value) || Boolean.valueOf(value).booleanValue()) {
            result = true;
        }
        return result;
    }

    public static Date getDate(HttpServletRequest request, String param, String datePattern) {
        Date result = null;
        SimpleDateFormat dateFormat = null;
        dateFormat = datePattern != null ? new SimpleDateFormat(datePattern) : new SimpleDateFormat();
        String value = Form.get(request, param);
        if (value != null) {
            try {
                result = dateFormat.parse(value);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getPassword(HttpServletRequest request, String param, String currentValue) {
        String value = StringUtils.trimToNull((String)request.getParameter(param));
        if ("****".equals(value)) {
            value = currentValue;
        }
        return value;
    }

    public static String getPasswordAndConfirm(HttpServletRequest request, FormErrors errors, String param, String paramConfirm, String currentValue) {
        String value = StringUtils.trimToNull((String)request.getParameter(param));
        String valueConfirm = StringUtils.trimToNull((String)request.getParameter(paramConfirm));
        if (value == null && valueConfirm == null) {
            return null;
        }
        if ("****".equals(value) && valueConfirm == null) {
            return currentValue;
        }
        if (valueConfirm == null) {
            errors.addFieldError(param, "Please confirm the new password");
            return null;
        }
        if (!valueConfirm.equals(value)) {
            errors.addFieldError(param, "Password and Confirmation did not match");
            return null;
        }
        return value;
    }

    public static String getSecureValueAndConfirm(HttpServletRequest request, FormErrors errors, String param, String paramConfirm, String currentValue) {
        String value = StringUtils.trimToNull((String)request.getParameter(param));
        String valueConfirm = StringUtils.trimToNull((String)request.getParameter(paramConfirm));
        if (value == null && valueConfirm == null) {
            errors.addFieldError(param, "Value is required");
            return null;
        }
        if ("****".equals(value) && valueConfirm == null) {
            return currentValue;
        }
        if (valueConfirm == null) {
            errors.addFieldError(param, "Please confirm the new value");
            return null;
        }
        if (!valueConfirm.equals(value)) {
            errors.addFieldError(param, "Value and Confirmation did not match");
            return null;
        }
        return value;
    }

    public static Class<?> getClass(HttpServletRequest request, String param) throws ClassNotFoundException {
        String value = StringUtils.trimToNull((String)request.getParameter(param));
        return value == null ? null : Class.forName(value);
    }

    private Form() {
    }
}

