<%--
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Build
- IBM UrbanCode Deploy
- IBM UrbanCode Release
- IBM AnthillPro
- (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"     required="true"%>
<%@attribute name="list"     required="true"  type="java.lang.Object"%>
<%@attribute name="selectedValue" required="false" %>
<%@attribute name="unselectedText"  required="false" %>
<%@attribute name="enabled"  required="false" type="java.lang.Boolean"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:choose>
  <c:when test="${enabled == null || enabled}">
    <c:set var="cssClass" value="input"/>
    <c:set var="disabled" value=""/>
  </c:when>

  <c:otherwise>
    <c:set var="cssClass" value="inputdisabled"/>
    <c:set var="disabled" value=" disabled"/>
  </c:otherwise>
</c:choose>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</b>
  </c:when>
  
  <c:otherwise>
    <select name="${fn:escapeXml(name)}" class="${fn:escapeXml(cssClass)}"${fn:escapeXml(disabled)}>
      <c:choose>
        <c:when test="${fn:length(unselectedText) > 0}">
          <option selected value="">${fn:escapeXml(unselectedText)}</option>
        </c:when>
        
        <c:otherwise>
          <option selected value="">-- Make Selection --</option>
        </c:otherwise>
      </c:choose>
  
      <c:forEach var="item" items="${list}">
        <c:choose>
          <c:when test="${item.name == selectedValue}">
            <c:set var="selected" value="selected"/>
          </c:when>
    
          <c:otherwise>
            <c:set var="selected" value=""/>
          </c:otherwise>
        </c:choose>
    
        <option ${fn:escapeXml(selected)} value="${fn:escapeXml(item.name)}">${fn:escapeXml(item.name)}</option>
      </c:forEach>
    </select>
  </c:otherwise>
</c:choose>
