/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.cache;

import com.urbancode.commons.web.cache.CacheException;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache {
    private static Cache instance = new Cache();
    private Hashtable<HttpSession, Hashtable<Class<? extends AbstractEntity<?>>, Hashtable<Serializable, AbstractEntity<?>>>> cache = new Hashtable();

    public static Cache getInstance() {
        return instance;
    }

    private Cache() {
    }

    private Hashtable<Serializable, AbstractEntity<?>> getClassCache(HttpSession session, Class<? extends AbstractEntity<?>> objectClass) {
        Hashtable<Serializable, Object> classCache;
        Hashtable<Class<Object>, Hashtable<Serializable, Object>> sessionCache = this.cache.get(session);
        if (sessionCache == null) {
            sessionCache = new Hashtable();
            this.cache.put(session, sessionCache);
        }
        if ((classCache = sessionCache.get(objectClass)) == null) {
            classCache = new Hashtable();
            sessionCache.put(objectClass, classCache);
        }
        return classCache;
    }

    public void put(HttpSession session, AbstractEntity<?> object) throws CacheException {
        Serializable objectId;
        Class<?> objectClass = object.getClass();
        Hashtable<Serializable, AbstractEntity<?>> classCache = this.getClassCache(session, objectClass);
        if (classCache.containsKey(objectId = object.getId())) {
            throw new CacheException("Object of class " + objectClass.getCanonicalName() + " with id " + objectId + " is already cached in session " + session.getId());
        }
        classCache.put(objectId, object);
    }

    public void replace(HttpSession session, AbstractEntity<?> object) {
        Serializable objectId;
        Class<?> objectClass = object.getClass();
        Hashtable<Serializable, AbstractEntity<?>> classCache = this.getClassCache(session, objectClass);
        if (classCache.containsKey(objectId = object.getId())) {
            this.remove(session, object);
        }
        classCache.put(objectId, object);
    }

    public AbstractEntity<?> get(HttpSession session, Class<? extends AbstractEntity<?>> objectClass, Serializable id) {
        Hashtable<Serializable, AbstractEntity<?>> classCache = this.getClassCache(session, objectClass);
        return classCache.get(id);
    }

    public List<AbstractEntity<?>> getAll(HttpSession session, Class<? extends AbstractEntity<?>> objectClass) {
        ArrayList result = new ArrayList();
        Hashtable<Serializable, AbstractEntity<?>> classCache = this.getClassCache(session, objectClass);
        result.addAll(classCache.values());
        return result;
    }

    public void remove(HttpSession session, Class<? extends AbstractEntity<?>> objectClass, Serializable id) {
        Hashtable<Serializable, AbstractEntity<?>> classCache = this.getClassCache(session, objectClass);
        classCache.remove(id);
    }

    public void remove(HttpSession session, AbstractEntity<?> object) {
        Class<?> objectClass = object.getClass();
        Serializable id = object.getId();
        this.remove(session, objectClass, id);
    }

    public void removeSessionCache(HttpSession session) {
        this.cache.remove(session);
    }

    public String toString() {
        return this.cache.toString();
    }
}

