/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import com.urbancode.commons.web.proxy.KeyedLockManager;
import com.urbancode.commons.web.proxy.ProxyResponseHeader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyResponse
implements Closeable {
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";
    public static final String MODIFIED_SINCE_HEADER = "If-Modified-Since";
    boolean closed = false;
    int statusCode;
    String statusReason;
    List<ProxyResponseHeader> headers;
    InputStream entity;
    KeyedLockManager.LockGrant lockGrant;

    public static DateFormat newHeaderDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public Date getLastModified() {
        Date result = null;
        ProxyResponseHeader header = this.getFirstHeader(LAST_MODIFIED_HEADER);
        if (header != null) {
            DateFormat headerDateFormat = ProxyResponse.newHeaderDateFormat();
            String headerValue = header.getValue();
            try {
                result = headerDateFormat.parse(headerValue);
            }
            catch (java.text.ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    protected ProxyResponseHeader getFirstHeader(String headerName) {
        for (ProxyResponseHeader h : this.getHeaders()) {
            if (!h.getName().equalsIgnoreCase(headerName)) continue;
            return h;
        }
        return null;
    }

    protected ContentType getContentType() {
        ProxyResponseHeader h = this.getFirstHeader("Content-Type");
        if (h == null) {
            return null;
        }
        try {
            return new ContentType(h.getValue());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getMimeType() {
        ContentType contentType = this.getContentType();
        String baseType = null;
        if (contentType != null) {
            baseType = contentType.getBaseType();
        }
        return baseType;
    }

    public Charset getCharset() {
        ContentType contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        String charsetName = contentType.getParameter("charset");
        Charset charset = null;
        if (charsetName != null) {
            charset = Charset.forName(charsetName);
        }
        return charset;
    }

    public List<ProxyResponseHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    void setHeaders(List<ProxyResponseHeader> headers) {
        this.headers = Collections.unmodifiableList(new ArrayList<ProxyResponseHeader>(headers));
    }

    public InputStream getEntity() throws IOException {
        if (this.closed) {
            throw new IOException("ProxyResponse is closed");
        }
        return this.entity;
    }

    void setEntity(InputStream entity) {
        this.entity = entity;
    }

    @Override
    public void close() throws IOException {
        if (this.entity != null) {
            this.entity.close();
        }
        if (this.lockGrant != null) {
            this.lockGrant.release();
        }
        this.closed = true;
    }
}

