/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile
final def javaHome = System.getenv('JAVA_HOME')
final def pluginHome = System.getenv("PLUGIN_HOME");

final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

final def javaFile = new File(new File(javaHome), 'bin/java' + (apTool.isWindows ? '.exe' : ''))
final def udClientJarFile = new File(new File(pluginHome), 'lib/udclient.jar')

def automation              = props['automation']
def url                     = props['automation/url']
def user                    = props['automation/user']
def ucdAuthToken            = props['automation/authToken']
def password                = props['automation/passScript']?.trim() ?: props['automation/password']
def componentName           = props['componentName']
def versionName             = props['versionName']
def description             = props['versionDesc']
def includes                = props['includes']
def excludes                = props['excludes']

UCDBase ucd = new UCDBase()
ucd.workDir = workDir
ucd.javaFile = javaFile
ucd.udClientJarFile = udClientJarFile

ucd.url = url
ucd.user = user
ucd.password = password
ucd.ucdAuthToken = ucdAuthToken

ucd.component = componentName
ucd.version = versionName
ucd.isWindows = apTool.isWindows

// Try to create the version
def versionId = ucd.createVersion(description)
if (versionId) {
    println "Created version ${versionName} on component ${componentName} with id ${versionId}"
    apTool.setOutputProperty("buildlife/udeploy.versionId", versionId)
    apTool.setOutputProperties()
}
ucd.publishFiles(workDir.absolutePath, includes, excludes)

apTool.setOutputProperty("buildlife/artifact.repository.prop.sheet.${automation}", automation)
apTool.storeOutputProperties()
