/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.authentication.HttpAuthenticator;
import com.urbancode.commons.web.controller.ControllerServlet;
import com.urbancode.commons.web.util.RequestUtil;
import com.urbancode.security.SecurityUser;
import com.urbancode.security.authentication.AuthenticationException;
import com.urbancode.security.authentication.CurrentUserHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AuthenticationFiler
implements Filter {
    private static Logger logger = Logger.getLogger(AuthenticationFiler.class);
    private List<String> ignoredServletPaths = new ArrayList<String>();

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String loginTaskMethod = WebConfig.getInstance().getLoginFormTaskMethod();
        String loginProcessingTaskMethod = WebConfig.getInstance().getLoginTaskMethod();
        String logoutProcessingTaskMethod = WebConfig.getInstance().getLogoutTaskMethod();
        String passwordRecoveryTaskMethod = WebConfig.getInstance().getPasswordRecoveryTaskMethod();
        List<String> publicAreaPatterns = WebConfig.getInstance().getPublicAreaPatterns();
        String servletPath = request.getServletPath();
        if (!this.ignoredServletPaths.contains(servletPath)) {
            String className = null;
            String methodName = null;
            try {
                methodName = ControllerServlet.extractMethodName(request.getPathInfo());
                className = ControllerServlet.extractClassName(request.getPathInfo());
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean staticResourceCalled = request.getRequestURI().endsWith(".jpg") || request.getRequestURI().endsWith(".jpeg") || request.getRequestURI().endsWith(".gif") || request.getRequestURI().endsWith(".png") || request.getRequestURI().endsWith(".css") || request.getRequestURI().endsWith(".js") || request.getRequestURI().endsWith(".jsp") || request.getRequestURI().endsWith(".ico");
            String requestedTaskMethod = null;
            if (!staticResourceCalled && className != null) {
                try {
                    Class<?> taskClass = Class.forName(className);
                    if (methodName != null) {
                        requestedTaskMethod = ControllerServlet.classMethodUrl(taskClass, methodName);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (!logoutProcessingTaskMethod.equals(requestedTaskMethod)) {
                SecurityUser user;
                boolean regularTaskMethodCalled;
                boolean publicAreaRequested = false;
                boolean bl = regularTaskMethodCalled = requestedTaskMethod == null && !staticResourceCalled || requestedTaskMethod != null && !requestedTaskMethod.equals(loginTaskMethod) && !requestedTaskMethod.equals(loginProcessingTaskMethod) && !requestedTaskMethod.equals(logoutProcessingTaskMethod) && !requestedTaskMethod.equals(passwordRecoveryTaskMethod);
                if (regularTaskMethodCalled && requestedTaskMethod != null) {
                    String publicAreaPattern;
                    Pattern pattern;
                    Matcher matcher;
                    Iterator<String> i$ = publicAreaPatterns.iterator();
                    while (i$.hasNext() && !(publicAreaRequested = (matcher = (pattern = Pattern.compile(publicAreaPattern = i$.next())).matcher(requestedTaskMethod)).matches())) {
                    }
                }
                if ((user = HttpAuthenticator.getAuthenticatedUser(request)) == null) {
                    try {
                        user = HttpAuthenticator.authenticate(request, response, true, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (CurrentUserHelper.hasCurrent()) {
                    CurrentUserHelper.getCurrent().unbindThread();
                }
                if (user != null) {
                    try {
                        CurrentUserHelper currentUserHelper = new CurrentUserHelper(user);
                        currentUserHelper.bindCurrentThread();
                    }
                    catch (AuthenticationException e) {
                        logger.warn((Object)("Binding authenticated user (" + user.getName() + ") to current thread"), (Throwable)e);
                    }
                }
                if (!publicAreaRequested && regularTaskMethodCalled && user == null) {
                    if (requestedTaskMethod != null) {
                        RequestUtil.setPreviousRequestedUrl(request);
                    } else {
                        requestedTaskMethod = "/";
                    }
                    logger.debug((Object)("Attempt to access " + requestedTaskMethod + " by an unauthorized user."));
                    logger.debug((Object)("Redirecting to the default task: " + loginTaskMethod));
                    response.sendRedirect(request.getContextPath() + loginTaskMethod);
                } else {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig config) {
        String ignoredServletPaths = config.getInitParameter("ignored-servlet-paths");
        if (ignoredServletPaths != null) {
            String[] split;
            for (String s : split = ignoredServletPaths.split(";")) {
                s = s.trim();
                this.ignoredServletPaths.add(s);
            }
        }
        logger.info((Object)"Filter initialized");
        if (!this.ignoredServletPaths.isEmpty()) {
            logger.info((Object)("    ignored servlet paths: " + this.ignoredServletPaths));
        }
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

