<%--
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Build
- IBM UrbanCode Deploy
- IBM UrbanCode Release
- IBM AnthillPro
- (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"     required="true"%>
<%@attribute name="list"     required="true"  type="java.lang.Object"%>
<%@attribute name="selectedValue" required="false" %>
<%@attribute name="enabled"  required="false" type="java.lang.Boolean"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:choose>
  <c:when test="${enabled == null || enabled}">
    <c:set var="cssClass" value="button"/>
    <c:set var="disabled" value=""/>
  </c:when>

  <c:otherwise>
    <c:set var="cssClass" value="buttondisabled"/>
    <c:set var="disabled" value=" disabled"/>
  </c:otherwise>
</c:choose>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</b>
  </c:when>
  
  <c:otherwise>
    <table class="radio-table" border="0" cellpadding="4" cellspacing="0">
    <c:forEach var="item" items="${list}">
      <!-- item type = ${item.type} -->
      <c:choose>
        <c:when test="${item.type == selectedValue}">
          <c:set var="checked" value="checked"/>
        </c:when>
    
        <c:otherwise>
          <c:set var="checked" value=""/>
        </c:otherwise>
      </c:choose>
    
      <tr>
        <td> <input ${checked} type="RADIO" class="radio" name="${fn:escapeXml(name)}" value="${fn:escapeXml(item.name)}" ${disabled}> </td>
        <td> ${fn:escapeXml(item.name)} </td>
      </tr>
    
    </c:forEach>
    </table>
  </c:otherwise>
</c:choose>
