<%--
- Licensed Materials - Property of IBM Corp.
- IBM UrbanCode Build
- IBM UrbanCode Deploy
- IBM UrbanCode Release
- IBM AnthillPro
- (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
--%>
<%@tag body-content="empty" %>

<%--
  Syntax:
    <ucf:text name="name" value="value" enable="true">

  Output:
    <input type="text" name="name" value="value">
    <input type="text" name="name" value="value" disabled>
--%>

<%@attribute name="name" required="true"%>
<%@attribute name="value" required="true"%>
<%@attribute name="checked" required="false"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="yesClicked" required="false"%>
<%@attribute name="noClicked" required="false"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:choose>
  <c:when test="${enabled == null || enabled}">
    <c:set var="disabled" value=""/>
  </c:when>

  <c:otherwise>
    <c:set var="disabled" value="disabled"/>
  </c:otherwise>
</c:choose>

<c:choose>
  <c:when test="${value}">
    <c:set var="yes" value="checked='checked'"/>
  </c:when>

  <c:otherwise>
    <c:set var="no" value="checked='checked'"/>
  </c:otherwise>
</c:choose>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</span>
  </c:when>
  
  <c:otherwise>
    <input class="radio" type="radio" name="${fn:escapeXml(name)}" value="true" ${yes} ${disabled} <c:if test="${!empty yesClicked}">onclick="${yesClicked}"</c:if>> Yes<br>
    <input class="radio" type="radio" name="${fn:escapeXml(name)}" value="false" ${no} ${disabled} <c:if test="${!empty noClicked}">onclick="${noClicked}"</c:if>> No
  </c:otherwise>
</c:choose>
