/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.util.RequestParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CacheBustFilter
implements Filter {
    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String cacheBust;
        Cookie[] cookies;
        String serverVersion = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream in = loader.getResourceAsStream("installed.version");
            if (in != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(in);
                    serverVersion = properties.getProperty("installed.version");
                }
                catch (Exception e) {
                }
                finally {
                    IO.closeNoThrow((InputStream)in);
                }
            }
            request.setAttribute("serverVersion", serverVersion);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Boolean isDev = null;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String queryString = httpRequest.getQueryString();
        Map<String, String> queryMap = RequestParser.parseQueryString(queryString);
        String devparam = queryMap.get("dev");
        if (devparam != null) {
            isDev = Boolean.valueOf(devparam);
        }
        if (isDev == null && request instanceof HttpServletRequest && (cookies = httpRequest.getCookies()) != null) {
            for (Cookie c : cookies) {
                if (!"dev".equals(c.getName())) continue;
                isDev = Boolean.valueOf(c.getValue());
                break;
            }
        }
        if (isDev == null && serverVersion != null && serverVersion.endsWith("_dev")) {
            isDev = true;
        }
        if (isDev == null) {
            isDev = false;
        }
        if (isDev.booleanValue()) {
            cacheBust = String.valueOf(System.currentTimeMillis());
        } else {
            long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            cacheBust = "v" + String.valueOf(jvmStartTime);
        }
        request.setAttribute("cacheBust", (Object)cacheBust);
        request.setAttribute("serverVersionIsDev", (Object)isDev);
        filterChain.doFilter(request, response);
    }
}

