/*
 * Licensed Materials - Property of HCL
 * UrbanCode Build
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
 import com.urbancode.air.AirPluginTool
 import org.apache.log4j.Level
 import org.apache.log4j.Logger

 //------------------------------------------------------------------------------
 // GET ALL INPUT PARAMETERS
 //------------------------------------------------------------------------------
 final File workDir = new File('.').canonicalFile
 final String javaHome = System.getenv('JAVA_HOME')
 final String pluginHome = System.getenv("PLUGIN_HOME")
 final String webUrl = System.getenv('WEB_URL')
 final String buildLifeId = System.getenv('BUILD_LIFE_ID')

 final AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
 final Properties props = apTool.getStepProperties()

 final File javaFile = new File(new File(javaHome),
     'bin' + File.pathSeparator + 'java' + (apTool.isWindows ? '.exe' : ''))
 final File udClientJarFile = new File(new File(pluginHome),
     'lib' + File.pathSeparator + 'udclient.jar')

 String ucdUrl = props['automation/url']
 String ucdUser = props['automation/user']
 String ucdPassword = props['automation/passScript'] ?: props['automation/password']
 String ucdAuthToken = props['automation/authToken']

 /*Configure Log4j logger */
 String logLevel = props['loggerLevel']
 Logger.getRootLogger().setLevel(Level.toLevel(logLevel)) // Configure log level for all loggers
 Logger logger = Logger.getLogger(getClass()) // Get the logger for this class

 UCDRestHelper ucdHelper = new UCDRestHelper(ucdUrl, ucdUser, ucdPassword, ucdAuthToken)
 AppProcessRequest appProcessRequest = new AppProcessRequest(props)

 logger.info("Deploying with snapshot.")
 String processId = ucdHelper.deployWithSnapshot(appProcessRequest)
 logger.info("Successfully deploy snapshot.")

 apTool.setOutputProperty("processId", processId)
 apTool.storeOutputProperties()
