/*
 * Licensed Materials - Property of HCL
 * UrbanCode Build
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
import org.codehaus.jettison.json.JSONObject

class AppProcessRequest {
    String application
    String applicationProcess
    String environment
    String snapshot
    String description
    boolean onlyChanged
    Map<String, String> properties

    public AppProcessRequest(Properties props) {
        application = props['application']
        applicationProcess = props['applicationProcess']
        environment = props['environment']
        snapshot = props['snapshot']
        description = props['description']?.trim()
        onlyChanged = Boolean.valueOf(props['onlyChanged'])

        properties = parseProperties(props['properties']?.trim())

    }

    /*
     * Get a string representation of the application process request.
     */
    public String toString() {
        return "application=${application}, applicationProcess=${applicationProcess}, " +
            "environment=${environment}, snapshot=${snapshot}, description=${description}, " +
            "onlyChange=${onlyChanged}, properties=${properties}"
    }

    /**
     * Parse through newline separated list of property names and values delimited by '/'
     * @param unparsedProps
     */
    private Map<String, String> parseProperties(String unparsedProps) {
        Map<String, String> propMap = new HashMap<String, String>()

        for (String property : unparsedProps.tokenize("\n")) {
            List<String> splitProp = property.tokenize("/")

            if (splitProp.size() > 1) {
                String propName = splitProp.get(0)
                String propValue = splitProp.get(1)

                propMap.put(propName, propValue)
            }
        }

        return propMap
    }
}
