/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class FrameOptionsFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(FrameOptionsFilter.class);
    private static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    private static final String OPTION_SAME_ORIGIN = "SAMEORIGIN";
    private static final String OPTION_ALLOW_FROM = "ALLOW-FROM";
    List<String> allowFroms = new ArrayList<String>();

    public void init(FilterConfig config) {
        logger.info((Object)"Filter initialized");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResonse = (HttpServletResponse)response;
            httpResonse.addHeader(X_FRAME_OPTIONS_HEADER, OPTION_SAME_ORIGIN);
            for (String allowFrom : this.allowFroms) {
                httpResonse.addHeader(X_FRAME_OPTIONS_HEADER, "ALLOW-FROM " + allowFrom.trim());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

