<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"         required="true"%>
<%@attribute name="list"         required="true"  type="java.lang.Object"%>

<%@attribute name="selectedId"   required="false"%>
<%@attribute name="selectedList" required="false" type="java.lang.Object"%>
<%@attribute name="excludedId"   required="false"%>
<%@attribute name="emptyMessage" required="false" type="java.lang.String"%>
<%@attribute name="canUnselect"  required="false" type="java.lang.Boolean"%>
<%@attribute name="enabled"      required="false" type="java.lang.Boolean"%>
<%@attribute name="multiple"     required="false" type="java.lang.Boolean"%>

<%@attribute name="id"           required="false" type="java.lang.String"%>
<%@attribute name="onChange"     required="false" type="java.lang.String"%>
<%@attribute name="optimizeOne"  required="false"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:choose>
  <c:when test="${enabled == null || enabled}">
    <c:set var="cssClass" value="input"/>
    <c:set var="disabled" value=""/>
  </c:when>

  <c:otherwise>
    <c:set var="cssClass" value="inputdisabled"/>
    <c:set var="disabled" value=" disabled='disabled'"/>
  </c:otherwise>
</c:choose>

<c:if test="${emptyMessage == null}">
  <c:choose>
    <c:when test="${canUnselect}">
      <c:set var="emptyMessage" value="None"/>
    </c:when>
    <c:otherwise>
      <c:set var="emptyMessage" value="Make Selection"/>
    </c:otherwise>
  </c:choose>
</c:if>


<c:if test="${fn:length(id)==0}">
  <c:set var="id" value="${name}"/>
</c:if>

<c:if test="${item.id != null}"><!--selected id ${item.id}--></c:if>

<c:choose>
  <c:when test="${optimizeOne && fn:length(list) == 1}">
    <c:forEach var="item" items="${list}">
      <input id="${fn:escapeXml(id)}" type="hidden" class="${fn:escapeXml(cssClass)}" name="${fn:escapeXml(name)}" value="${fn:escapeXml(item.id)}">
      ${fn:escapeXml(item.name)}
    </c:forEach>
  </c:when>
  <c:otherwise>
    <select id="${fn:escapeXml(id)}" class="${fn:escapeXml(cssClass)}" name="${fn:escapeXml(name)}"  ${disabled}
      <c:if test="${multiple}"> multiple</c:if>
      <c:if test="${fn:length(onChange)>0}"> onChange="${onChange}" </c:if>
      >
      <c:if test="${not multiple}">
      <option value="">-- <c:out value="${emptyMessage}" default="Make Selection"/> --</option>
      </c:if>

      <c:forEach var="item" items="${list}">
        <c:choose>
          <c:when test="${selectedList != null}">
            <c:set var="selected" value=""/>
            <c:forEach var="selectedItem" items="${selectedList}">
              <c:if test="${selectedItem.id == item.id}">
                <c:set var="selected" value="selected"/>
              </c:if>
            </c:forEach>
          </c:when>
          <c:when test="${item.id == selectedId && selectedId != '' && selectedId != null}">
            <c:set var="selected" value="selected"/>
          </c:when>

          <c:otherwise>
            <c:set var="selected" value=""/>
          </c:otherwise>
        </c:choose>

        <c:choose>
          <c:when test="${excludedId != null and excludedId == item.id}">
          </c:when>
          <c:otherwise>
        <option ${fn:escapeXml(selected)} value="${fn:escapeXml(item.id)}">${fn:escapeXml(item.name)}</option>
          </c:otherwise>
        </c:choose>
      </c:forEach>
    </select>
  </c:otherwise>
</c:choose>
