/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.controller.DynamicResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class FileDownloadResponse
implements DynamicResponse {
    private static final MimetypesFileTypeMap mimeTypeMap = new MimetypesFileTypeMap();
    private final String contentType;
    private final File contentFile;
    private final String contentAlias;
    private final InputStream inputStream;
    private final long size;

    public FileDownloadResponse(File contentFile) {
        this(null, contentFile, null);
    }

    public FileDownloadResponse(File contentFile, String alias) {
        this(null, contentFile, alias);
    }

    public FileDownloadResponse(String contentType, File contentFile, String contentAlias) {
        Validate.notNull((Object)contentFile, (String)"Content File can not be null");
        this.contentFile = contentFile;
        this.inputStream = null;
        this.contentAlias = StringUtils.defaultString((String)contentAlias, (String)contentFile.getName());
        this.contentType = StringUtils.defaultString((String)contentType, (String)mimeTypeMap.getContentType(contentFile));
        this.size = contentFile.length();
    }

    public FileDownloadResponse(InputStream inputStream, long size, String alias) {
        this(null, inputStream, size, alias);
    }

    public FileDownloadResponse(String contentType, InputStream inputStream, long size, String contentAlias) {
        Validate.notNull((Object)inputStream, (String)"Content stream can not be null");
        Validate.notNull((Object)contentAlias, (String)"An alias for input stream download is required");
        this.contentFile = null;
        this.inputStream = inputStream;
        this.contentAlias = contentAlias;
        this.contentType = StringUtils.defaultString((String)contentType, (String)mimeTypeMap.getContentType(contentAlias));
        this.size = size;
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.contentType);
        if (this.size <= Integer.MAX_VALUE) {
            response.setContentLength((int)this.size);
        }
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Content-disposition", this.getContentDisposition(request));
        InputStream in = this.getContentStream();
        try {
            ServletOutputStream os = response.getOutputStream();
            IO.copy((InputStream)in, (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            IO.close((InputStream)in);
        }
    }

    protected String getContentDisposition(HttpServletRequest request) {
        String header;
        try {
            header = "attachment; filename=\"" + this.contentAlias + "\"; filename*=UTF-8''" + URLEncoder.encode(this.contentAlias, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to produce header using UTF-8");
        }
        return header;
    }

    protected InputStream getContentStream() throws FileNotFoundException {
        return this.contentFile != null ? new FileInputStream(this.contentFile) : this.inputStream;
    }
}

