/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import org.apache.commons.lang3.StringUtils;

@BridgeMethodsAdded
public class CSVUtil {
    static final String PADDING_CHAR = "'";
    static final String[] FORMULA_CHARS = new String[]{"=", "+", "-", "@"};

    static String padFormulaChars(String field) {
        if (CSVUtil.isFormula(field)) {
            return PADDING_CHAR + field;
        }
        return field;
    }

    static boolean isFormula(String field) {
        return StringUtils.startsWithAny((CharSequence)field, (CharSequence[])FORMULA_CHARS);
    }

    public static String escapeValue(String value) {
        String escapedValue = "";
        if (value != null && value.length() > 0) {
            escapedValue = CSVUtil.padFormulaChars(value);
            boolean addQuotes = false;
            if (escapedValue.indexOf("\"") >= 0) {
                addQuotes = true;
                escapedValue = escapedValue.replaceAll("\"", "\"\"");
            }
            if (escapedValue.indexOf(32) >= 0 || escapedValue.indexOf(44) >= 0 || escapedValue.indexOf(10) >= 0 || escapedValue.indexOf(13) >= 0 || escapedValue.indexOf(9) >= 0) {
                addQuotes = true;
            }
            if (addQuotes) {
                escapedValue = "\"" + escapedValue + "\"";
            }
        }
        return escapedValue;
    }
}

