/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.authentication.HttpAuthenticator;
import com.urbancode.commons.web.controller.ControllerServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SecureRequestFiler
implements Filter {
    private static Logger logger = Logger.getLogger(SecureRequestFiler.class);
    private List<String> ignoredServletPaths = new ArrayList<String>();
    private int httpPort = 8080;
    private int httpsPort = 8443;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String servletPath = request.getServletPath();
        if (!this.ignoredServletPaths.contains(servletPath)) {
            String redirect;
            String scheme;
            boolean authenticated = HttpAuthenticator.getAuthenticatedUser(request) != null;
            String uri = request.getRequestURI();
            String query = request.getQueryString();
            String server = request.getServerName();
            List<String> publicAreaPatterns = WebConfig.getInstance().getPublicAreaPatterns();
            List<String> secureAreaPatterns = WebConfig.getInstance().getSecureAreaPatterns();
            String className = null;
            String methodName = null;
            try {
                methodName = ControllerServlet.extractMethodName(request.getPathInfo());
                className = ControllerServlet.extractClassName(request.getPathInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean staticResourceCalled = request.getRequestURI().endsWith(".jpg") || request.getRequestURI().endsWith(".jpeg") || request.getRequestURI().endsWith(".gif") || request.getRequestURI().endsWith(".png") || request.getRequestURI().endsWith(".css") || request.getRequestURI().endsWith(".js") || request.getRequestURI().endsWith(".jsp") || request.getRequestURI().endsWith(".ico");
            String requestedTaskMethod = null;
            if (!staticResourceCalled && className != null) {
                try {
                    Class<?> taskClass = Class.forName(className);
                    if (methodName != null) {
                        requestedTaskMethod = ControllerServlet.classMethodUrl(taskClass, methodName);
                    }
                }
                catch (ClassNotFoundException taskClass) {
                    // empty catch block
                }
            }
            if (requestedTaskMethod == null && !staticResourceCalled) {
                requestedTaskMethod = "/";
            }
            boolean publicAreaRequested = false;
            boolean secureAreaRequested = false;
            if (requestedTaskMethod != null) {
                String secureAreaPattern;
                String publicAreaPattern;
                Pattern pattern;
                Matcher matcher;
                Iterator<String> iterator = publicAreaPatterns.iterator();
                while (iterator.hasNext() && !(publicAreaRequested = (matcher = (pattern = Pattern.compile(publicAreaPattern = iterator.next())).matcher(requestedTaskMethod)).matches())) {
                }
                iterator = secureAreaPatterns.iterator();
                while (iterator.hasNext() && !(secureAreaRequested = (matcher = (pattern = Pattern.compile(secureAreaPattern = iterator.next())).matcher(requestedTaskMethod)).matches())) {
                }
            }
            if (uri.endsWith("favicon.ico")) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else if (!(authenticated || publicAreaRequested || request.getScheme().toLowerCase().equals("https"))) {
                logger.debug((Object)("Redirecting " + uri + " to HTTPS"));
                scheme = "https";
                redirect = scheme + "://" + server + ":" + this.httpsPort + uri;
                if (query != null) {
                    redirect = redirect + "?" + query;
                }
                response.sendRedirect(redirect);
            } else if ((authenticated || publicAreaRequested) && !request.getScheme().toLowerCase().equals("http") && !secureAreaRequested) {
                logger.debug((Object)("Redirecting " + uri + " to HTTP"));
                scheme = "http";
                redirect = scheme + "://" + server + ":" + this.httpPort + uri;
                if (query != null) {
                    redirect = redirect + "?" + query;
                }
                response.sendRedirect(redirect);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig config) {
        String ignoredServletPaths = config.getInitParameter("ignored-servlet-paths");
        if (ignoredServletPaths != null) {
            String[] split;
            for (String s : split = ignoredServletPaths.split(";")) {
                s = s.trim();
                this.ignoredServletPaths.add(s);
            }
        }
        try {
            this.httpPort = Integer.parseInt(config.getInitParameter("http-port"));
        }
        catch (Exception e) {
            logger.warn((Object)("Incorrect HTTP port value: " + config.getInitParameter("http-port") + ", using default " + this.httpPort));
        }
        try {
            this.httpsPort = Integer.parseInt(config.getInitParameter("https-port"));
        }
        catch (Exception e) {
            logger.warn((Object)("Incorrect HTTPS port value: " + config.getInitParameter("https-port") + ", using default " + this.httpsPort));
        }
        logger.info((Object)"Filter initialized");
        if (!this.ignoredServletPaths.isEmpty()) {
            logger.info((Object)("    ignored servlet paths: " + this.ignoredServletPaths));
        }
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

