/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata.crypto;

import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CipherAlgorithmAES128
implements CipherAlgorithm {
    private final String algorithm = "AES";
    private final String mode = "CBC";
    private final String padding = "PKCS5Padding";

    CipherAlgorithmAES128() throws GeneralSecurityException {
        this.testAlgorithms();
    }

    public String toString() {
        return this.getName();
    }

    public int getKeyLength() {
        return 16;
    }

    public String getName() {
        return "AES:128";
    }

    public String getJavaName() {
        return "AES/CBC/PKCS5Padding";
    }

    public Cipher createCipher(SecretKey key, byte[] initializationVector, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(this.getJavaName());
            cipher.init(mode, (Key)key, new IvParameterSpec(initializationVector));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] createInitializationVector(SecureRandom r) {
        byte[] b = new byte[this.getKeyLength()];
        r.nextBytes(b);
        return b;
    }

    public SecretKey createKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, "AES");
    }

    private void testAlgorithms() throws GeneralSecurityException {
        SecretKey key = this.createKey(new byte[this.getKeyLength()]);
        Cipher cipher = Cipher.getInstance(this.getJavaName());
        cipher.init(1, (Key)key, new IvParameterSpec(new byte[this.getKeyLength()]));
    }
}

