/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Build
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.salesforce

public class SalesForceHelper {
    def proxyUser
    def proxyPassword
    def proxyHost
    def proxyPort
    def socksProxyHost
    def socksProxyPort

    public SalesForceHelper(props) {
        this.proxyUser = props['automation/proxyUser']
        this.proxyPassword = ['automation/proxyPassword']
        this.proxyHost = props['automation/proxyHost']
        this.proxyPort = props['automation/proxyPort']
        this.socksProxyHost = props['automation/socksProxyHost']
        this.socksProxyPort = props['automation/socksProxyPort']

        if (!proxyPort) {
            proxyPort = 80
        }
        if (!socksProxyPort) {
            socksProxyPort = 1080
        }
    }

    def AntBuilder buildAnt() {
        def ant = new AntBuilder()
        if (proxyHost) {
            if (proxyUser && proxyPassword) {
                ant.setproxy(
                        proxyhost: proxyHost,
                        proxyport: proxyPort,
                        proxyuser: proxyUser,
                        proxypassword: proxyPassword
                )
            }
            else {
                ant.setproxy(
                        proxyhost: proxyHost,
                        proxyport: proxyPort
                )
            }
        }
        else if (socksProxyHost) {
            if (proxyUser && proxyPassword) {
                ant.setproxy(
                        socksproxyhost: socksProxyHost,
                        socksproxyport: socksProxyPort,
                        proxyuser: proxyUser,
                        proxypassword: proxyPassword
                )
            }
            else {
                ant.setproxy(
                        socksproxyhost: socksProxyHost,
                        socksproxyport: socksProxyPort
                )
            }
        }
        return ant
    }
}