/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Build
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

import com.sun.java.util.jar.pack.PackerImpl.DoPack.InFile

import org.apache.tools.ant.BuildLogger

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String password = props['automation/password']
String username = props['automation/username']
String serverUrl = props['automation/serverUrl']
String checkOnly = props['checkOnly']
String maxPoll = props['maxPoll']?:"200"
String pollWaitMillis = props['pollWaitMillis']?:"10000"
String deployRoot = props['deployRoot']
String testLevel = props['testLevel']
String testList = props['testList']
boolean isRollback = Boolean.valueOf(props['isRollback'])

def deployRootPath = null
String[] testNames = testList.split('\n')*.trim()

if (!(new File(deployRoot).exists())) {
    println("[ERROR] Deployment root '${deployRoot}' not set to a valid file or directory.")
    System.exit(1)
}
else if (new File(deployRoot).isAbsolute()) {
    deployRootPath = new File(deployRoot).canonicalPath
}
else {
    deployRootPath = new File(workDir, deployRoot).canonicalPath
}

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

//If check only is selected, get the deployment Id to set as an output property for later recent validation deployment
if (checkOnly == "true") {
    println("[ACTION] 'Check Only' selected. Testing deployments without saving to target...")

    //Setup print stream to redirect ant output to log file for parsing to get deployment Id
    String logFile = java.util.UUID.randomUUID().toString()
    println ("[INFO] Log file created: " + logFile)
    def logOutput = new PrintStream(new File(logFile))
    ant.project.getBuildListeners().each{
         //Ensure that only the BuildLogger element is operated on.
         if(it instanceof BuildLogger) {
             it.setOutputPrintStream(logOutput)
         }
    }

    ant.taskdef name: "sfDeploy", classname: "com.salesforce.ant.DeployTask"

    if (testLevel == "RunSpecifiedTests") {
        ant.sfDeploy(
                username: username,
                password: password,
                serverurl: serverUrl,
                deployRoot: deployRootPath,
                checkOnly: checkOnly,
                maxPoll: maxPoll,
                pollWaitMillis: pollWaitMillis,
                testLevel: testLevel
        ) {
            testNames.each { testName ->
                runTest(testName)
            }
        }
    }
    else {
        ant.sfDeploy(
            username: username,
            password: password,
            serverurl: serverUrl,
            deployRoot: deployRootPath,
            checkOnly: checkOnly,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis,
            testLevel: testLevel
        )
    }

    //parse log file to set the deployment Id as an output property
    try {
        File infile = new File(logFile)
        infile.deleteOnExit()
        def lines = infile.readLines()
        String recentValidationId = "null"
        lines.each {String line ->
            println line
            if (line.contains("[sfDeploy] Finished request")) {
                def arrayWithId = line.split(" ")
                //Deployment ID will always be 4th in array according to ant-salesforce API
                recentValidationId = arrayWithId[4]
            }
        }
        println ("[ACTION] Setting recentValidationId as output property: " + recentValidationId)
        airTool.setOutputProperty("recentValidationId", recentValidationId)
        airTool.setOutputProperties()
    }
    catch (Exception e) {
        println ("[ERROR] Failed to set recentValidationId as output property: " + e.getMessage())
        System.exit(1)
    }
}
else {
    println("[ACTION] Deploying from '${deployRoot}'...")

    ant.taskdef name: "sfDeploy", classname: "com.salesforce.ant.DeployTask"
    if (testLevel == "RunSpecifiedTests") {
        ant.sfDeploy(
                username: username,
                password: password,
                serverurl: serverUrl,
                deployRoot: deployRootPath,
                maxPoll: maxPoll,
                pollWaitMillis: pollWaitMillis,
                testLevel: testLevel
        ) {
            testNames.each { testName ->
                runTest(testName)
            }
        }
    }
    else {
        ant.sfDeploy(
            username: username,
            password: password,
            serverurl: serverUrl,
            deployRoot: deployRootPath,
            rollbackOnError: isRollback,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis,
            testLevel: testLevel
        )
    }
}

//deployRoot: "tools/sample/codepkg",
